#!/bin/sh -e 

# globale Funktionen und Defines inkludieren
. '/etc/bat60_scripts/scripts/includes/functions_global.sh'

is_logopt=true
FHSKPR=$1
updt_files_dir=$(find_update_dir)

###############################################
#		@brief	Updatet Controller durch das angegebene Schnittstelle
#		mit der angegebenen Adresse und dem Filenamen
#
function reinvoke_target
{
	local iface=$1
	local addr=$2
	local reinvoke_result=0
	
	if [ -z $iface ] ; then
		bat_log "Fatal error: no Iface"
		exit 1
	fi
	
	if [ -z $addr ] ; then
		bat_log "Fatal error: no Address"
		exit 1
	fi
	
	bat_log "bat60_reinvokeisp -d $iface -t $addr -v -v 2>&1"
	
#	Jede ausgegebene Zeile wird sofort in Log geschieben	
	while read -r reinvoke_opt ; do
        if [[ $reinvoke_opt == *"REINVOKEISP_EXIT_STATUS="* ]] ; then
			reinvoke_result=$(echo $update_opt | sed "s|REINVOKEISP_EXIT_STATUS=||g")
        fi

        bat_log "$reinvoke_opt"
    #done < <(bat60_reinvokeisp -d $iface -t $addr -v -v 2>&1 ;  echo "REINVOKEISP_EXIT_STATUS=$?" )
    done < <(bat60_cmd --execute=reinvokeisp -d $iface -t $addr -v -v 2>&1 ;  echo "REINVOKEISP_EXIT_STATUS=$?" ) 

    bat_log "Reinvoke result $reinvoke_result"
	
	return $reinvoke_result
}

###############################################
#		@brief	Updatet Controller durch das angegebene Schnittstelle
#		mit der angegebenen Adresse und dem Filenamen
#
function update_target
{
	if [ "$#" -lt 4 ] ; then
		echo "Too few args to turn_semitransparency" 1>&2
		return 1
	fi

	local iface=$1
	local addr=$2
	local file=$3
	local l_is_reinvoke=$4
	local update_result=0
	local l_reinvoke_param=''
	local l_tmp_fname=$file
	local l_local_fname=$(clean_filename -p $file)
	local l_int_sd=$(find_int_sd)
	
	if [ -z "$iface" ] ; then
		bat_log "Fatal error: no Iface"
		exit 1
	fi
	
	if [ -z "$addr" ] ; then
		bat_log "Fatal error: no Address"
		exit 1
	fi

	if [ $l_is_reinvoke == true ] ; then
		l_reinvoke_param='--reinvokeisp'
	fi
	
	bat_log "Trying to copy update file to intern SD-card"
	
	#	Datei kopieren
	if [[ $l_int_sd != "" ]] ; then
		mkdir -p "$l_int_sd/update_tmp"
		cp -Rf "$file" "$l_int_sd/update_tmp"
		l_tmp_fname="$l_int_sd/update_tmp/$l_local_fname"
		bat_log "File copied to intern SD-card"
	else
		l_tmp_fname=$file
		bat_log "Error while coping to intern SD-card. Updating from initial storage"
	fi
	
	bat_log "Updating target $addr through $iface"
	
#	Jede ausgegebene Zeile wird sofort in Log geschieben	
	while read -r update_opt ; do
        if [[ $update_opt == *"ISP_EXIT_STATUS="* ]] ; then
			update_result=$(echo $update_opt | sed "s|ISP_EXIT_STATUS=||g")
        fi

        bat_log "$update_opt"
    done < <(bat60_isp -d $iface --writefile=$addr,$l_tmp_fname $l_reinvoke_param -v -v 2>&1 ;  echo "ISP_EXIT_STATUS=$?" ) 

    bat_log "Update result $update_result"
    
	if [[ $l_int_sd != "" ]] ; then
		rm -Rf "$l_int_sd/update_tmp"
	fi
	
	return $update_result
	
}

###############################################################################

# Wenn keine Trigger-datei extistiert, bedeutet das, dass
# der Houskeeper noch nicht in RevokeISP ist
#if [ ! -e "$BAT_SCRIPTS/includes/tmp/houskeeper_revokeisp_trigger" ] ; then

#	bat_log "Reinvoking ISP on Houskeeper through $LINDIS_TRX_UART"
#	bat_log "After reinvoking ISP on Houskeeper will be reseted!"
#	bat_log "Creating re-invoke isp trigger file"
#	echo "HouseKeeper Revoke ISP" > "$BAT_SCRIPTS/includes/tmp/houskeeper_revokeisp_trigger"
	
#	sleep 2s

#	reinvoke_target $LINDIS_TRX_UART $COMM_ADDRESS_HOUSEKEEPER
#	res=$?

	# Hier wird nichts mehr ausgefuehrt...

#	if [ ! $res -eq 0 ] ; then
#		bat_log "Failed to re-invoke Houskeeper in ISP"
#	fi

#	sleep 5s

#fi # [ ! -e "houskeeper_revokeisp_trigger" ]

#elif [ -e "$BAT_SCRIPTS/includes/tmp/houskeeper_revokeisp_trigger" ] && [ ! -e "$BAT_SCRIPTS/includes/tmp/houskeeper_updated_trigger" ] && [ ! -e "$BAT_SCRIPTS/includes/tmp/houskeeper_update_failed_trigger" ] ; then
#	bat_log "Found reinvokeisp trigger file after Houskeeper ReinvokeISP"
#	bat_log "Creating Houskeeper update triger file"
	#rm -f "$BAT_SCRIPTS/includes/tmp/houskeeper_revokeisp_trigger"
#	echo "HouseKeeper updated" > "$BAT_SCRIPTS/includes/tmp/houskeeper_updated_trigger"
	bat_log "Starting Housekeeper Update"
	
	retries=3
	
	while [ $retries -gt 0 ] ; do
		update_target "$LINDIS_HSKPR_UART" "$COMM_ADDRESS_HOUSEKEEPER" "$updt_files_dir/$FHSKPR" false
		update_result=$?
		
		if [ $update_result -eq 0 ] ; then
			break
		fi
		
		let retries=$retries-1
		bat_log "Houskeeper's update failed. $retries retries remain(s)"
	done
	
	if [ $retries -eq 0 ] ; then
		bat_log "All retries by Houskeeper's update failed"
		echo "HouseKeeper update failed" > "$BAT_SCRIPTS/includes/tmp/houskeeper_update_failed_trigger"
		rm -f "$BAT_SCRIPTS/includes/tmp/houskeeper_updated_trigger"
		exit $update_result
	fi
	
# Sonst ist das Housekeeperupdate zu Ende
#else
#	bat_log "Found update trigger file after Houskeeper Update. Removing trigger files"
#	rm -f "$BAT_SCRIPTS/includes/tmp/houskeeper_revokeisp_trigger"
#	rm -f "$BAT_SCRIPTS/includes/tmp/houskeeper_updated_trigger"
#	rm -f "$BAT_SCRIPTS/includes/tmp/houskeeper_update_failed_trigger"
#fi # -e houskeeper_revokeisp_trigger && houskeeper_updated_triggerargc=1

#wenn Argumentanzahl nicht uebereinstimmt
if [ "$#" -lt $argc ] ; then
	echo "No file given to update with" 1>&2
	exit 1
fi

update_fname=$1
reinvoke=''

if [ ! -z "$2" ] && [[ "$2" == "--reinvokeisp" ]]; then
	reinvoke=true
fi

