#!/bin/bash -e

# globale Funktionen inkludieren
. '/etc/bat60_scripts/scripts/includes/functions_global.sh'

###############################################################################
##		Suche nach Updatearchiv
##		
bat_log 'Looking for update file'

tmp_dir="$TMP_DIR"

updt_dev=$(find_update_dev)
tx_var=$(get_transmitter_variant)
TX_VARIANT=$tx_var
export TX_VARIANT
# updt_file_archiv=$(find_update_file $updt_dev $tx_var)
bat_log "Variant $tx_var"
updt_file_archiv=$(find_update_file $updt_dev $tx_var)

UPDATE_FILE_ARCHIVE="$updt_file_archiv"
export UPDATE_FILE_ARCHIVE

if [ ! -e "$updt_file_archiv" ] ; then
	bat_log 'No update archiv: ' "$updt_file_archiv"
	exit 0
fi

#################################################################################
## 	Updatefile gefunden, Update wird durchgeführt

init_update_screen

set_progress_bar 1

bat_log "Found update file: $updt_file_archiv"

print_update_msg 'Extracting data ...'

tar -zxvf $updt_file_archiv -C "$UPDATE_TMP_DIR" > /dev/null 2>&1				# entpacken

#updt_files_dir=$(find_update_dir)
UPDATE_FILES_DIR="$UPDATE_TMP_DIR/$WEATRONIC_FOLFER/update"
SERVICE_FILES_DIR="$UPDATE_TMP_DIR/$WEATRONIC_FOLFER/service"
updt_files_dir="$UPDATE_FILES_DIR"

export UPDATE_FILES_DIR
export SERVICE_FILES_DIR

bat_log "Update folder: $updt_files_dir"

#exit 0

print_update_msg 'Making preparations ...'

# Führe erstmal ein Service "VOR"-Skript
script_before="$SERVICE_FILES_DIR/$FILENAME_SCRIPT_BEFORE"
if [ -e "$script_before" ] ; then
	bash "$script_before"
fi

bash "$BAT_SCRIPTS/update_files/linux-update.sh"								# progress bar ends by 55%

###############################################################################
##		FIRMWARE-UPDATE
##

bat_log 'Getting into Firmware-phase'
bash "$BAT_SCRIPTS/update_files/fw_update.sh" "$updt_files_dir"					# progress bar ends by 95%

tmpdir_rx_fw="$updt_files_dir/rx-rw"

#	Rx-FW aktualisieren
if  test -e "$tmpdir_rx_fw"  ; then
	bat_log 'Updating Rx-FW ...'
	print_update_msg 'Updating Rx-FW ...'
	mkdir -p "$INTERNAL_SD/user-space/rx-fw"
	rm -f "$INTERNAL_SD/user-space/rx-fw"/*
	cp -Rf "$tmpdir_rx_fw"/* "$INTERNAL_SD/user-space/rx-fw"/
	rm -Rf "$tmpdir_rx_fw"
	bat_log "Rx-FW updated"
fi

###############################################################################
##		u-boot
##
bat_log 'Reading u-boot bootmode var'
bootmode=$(get_uboot_bootmode)
bat_log "U-boot bootmode var is $bootmode"
if [ "$bootmode" = "$UBOOT_BOOTMODE_HAVETRIED" ] ; then
	set_uboot_bootmode "$UBOOT_BOOTMODE_NORMAL"									# war Update, nächstes Mal normal booten
fi

if test -e "$ROOTFS_WRITTEN_FLAG_FILE" ; then
	bat_log "Root-FS flash update flag file found"
	rm -f "$ROOTFS_WRITTEN_FLAG_FILE"
fi

set_progress_bar 98

print_update_msg 'Executing post actions ...'

###############################################################################
# Führe zu Ende ein Service "NACH"-Skript
script_after="$SERVICE_FILES_DIR/$FILENAME_SCRIPT_AFTER"
if [ -e "$script_after" ] ; then
	bash "$script_after"
fi

set_progress_bar 100

destroy_update_screen