#!/bin/sh -e 

# globale Funktionen und Defines inkludieren
. '/etc/bat60_scripts/scripts/includes/functions_global.sh'

is_logopt=true

###############################################################################
# DevInfo lesen

iface=$(get_isp_iface "$CTRLR_NAME_TRANSCEIVER")
tmp_dir="$TMP_DIR"

dev_info=$(bat60_cmd --execute=getdevinfo -o 0x1 -t 0x60 -d $iface)

SAVE_IFS=$IFS
IFS=', ' read -a dev_info_array <<< "$dev_info"									# String in Array splitten
IFS=$SAVE_IFS

device_id="${dev_info_array[1]}"
device_serial="${dev_info_array[2]}"

bat_log "Read Device ID $device_id"
bat_log "Read Serial $device_serial"

echo "TRXC_DEVICE_ID=$device_id" > "$tmp_dir/TrxC.tmp"
echo "TRXC_DEVICE_SERIAL=$device_serial" >> "$tmp_dir/TrxC.tmp"

###############################################################################
# Update

bash "$BAT_SCRIPTS"/"update_files/separate/update_sep_tplt.sh" $1 "$COMM_ADDRESS_TRANSCEIVER" $2

###############################################################################
# DevInfo beschreiben

# | sed "s/^TRXC_DEVICE_ID\s*=\s*\(.*\)$/\1/g"
device_id=$(sed -e "/TRXC_DEVICE_SERIAL/g" "$tmp_dir/TrxC.tmp"  | sed "s/TRXC_DEVICE_ID\s*=\s*\(.*\)/\1/g")
device_serial=$(sed -e "/TRXC_DEVICE_ID/g" "$tmp_dir/TrxC.tmp" | sed "s/TRXC_DEVICE_SERIAL\s*=\s*\(.*\)/\1/g")

iface=$(get_isp_iface "$CTRLR_NAME_TRANSCEIVER")

dev_info=$(bat60_cmd --execute="setdevinfo,$device_id,$device_serial" -o 0x1 -t 0x60 -d $iface)

bat_log "Written Device ID $device_id"
bat_log "Written Serial $device_serial"

rm -fR "$tmp_dir/TrxC.tmp"