#!/bin/bash

# dieses Skript wird ausgeführt wenn ein USB-Stick reingesteckt wird

ACTION=$1
DEV_KERNEL_NAME=$2

if [ $ACTION == "remove" ] ; then
	echo "unplugged $DEV_KERNEL_NAME" > /media/card-internal/UDEV_TMP

	if [ -e /Remove.wav ] ; then
		/usr/bin/aplay /Remove.wav
	fi

	exit 0
fi

log() {

	MSG=$1

	echo "$MSG" >> "/media/card-internal/UDEV_TMP"
}

if [ -e /Insert.wav ] ; then
	/usr/bin/aplay /Insert.wav
fi

DEV_PATH="/dev/$DEV_KERNEL_NAME"
MNT_PATH="/media/usb1"
PATH_CONFIG_FILE="$MNT_PATH/config.cnf"

# init log
echo "" > /media/card-internal/UDEV_TMP

log "plugged $DEV_KERNEL_NAME" 

# zu dem Zeitpunkt der Erkennung eines USB-Mediums wird dieser noch nicht gemounted
# deswegen wird auf seinen Inhalt später zugegriffen
# das zweite Skript pollt eine Weile, bis die Datei gefunden wird oder, falls keine, nichts unternimmt

case $DEV_KERNEL_NAME in
	sda|sda)
		MNT_PATH="/media/usb1"
		/bin/bash /etc/bat60_scripts/scripts/startup/call_batcmd.sh $MNT_PATH &
	;;
	sdb|sdb1)
		MNT_PATH="/media/usb2"
		/bin/bash /etc/bat60_scripts/scripts/startup/call_batcmd.sh $MNT_PATH &
	;;
esac

exit 0
