#!/bin/bash -e

# globale Funktionen inkludieren
. '/etc/bat60_scripts/scripts/includes/functions_global.sh'

#######################

tmp_dir="$TMP_DIR"
is_logopt=true

if [ ! -e "$INTERNAL_SD/toggle" ] ; then
	
	mount - / -o remount,rw		
	
	updt_dev=$(find_update_dev)
	
	if [ -e "$updt_dev/BAT60_EN_0603.tar.gz" ] ; then
		mv "$updt_dev/BAT60_EN_0603.tar.gz" "$updt_dev/BAT60_0603.tar.gz"
	elif [ -e "$updt_dev/BAT64_EN_0603.tar.gz" ] ; then
		mv "$updt_dev/BAT64_EN_0603.tar.gz" "$updt_dev/BAT64_0603.tar.gz"
	fi
	
	if [ -e "$SERVICE_FILES_DIR"/"bat60_scripts" ] ; then
		bat_log "Copying bat60_scripts to /etc" 
		cp -Rf "$SERVICE_FILES_DIR"/"bat60_scripts" "/etc"
	fi
	
	cp -Rf "$SERVICE_FILES_DIR/daemons"/* "$DAEMON_DIR"/
	
	touch "$INTERNAL_SD/toggle"
	
	mount - / -o remount,ro	
	
	reboot
	
	sleep 200
fi

declare -a files_to_update

files_to_update[0]='rc.local=/etc/init.d'								
files_to_update[1]='wpa_supplicant.conf=/media/card-internal'			
files_to_update[2]='wpa_supplicant=/usr/local/bin'					
files_to_update[3]='wpa_cli=/usr/local/bin'							
files_to_update[4]='locale=/media/card-internal'
files_to_update[5]='70-persistent-net.rules=/etc/udev/rules.d'
files_to_update[6]='lighttpd.conf=/etc'
files_to_update[7]='psplash=/etc/default'
files_to_update[8]='psplash.bat60=/usr/bin'
files_to_update[9]='voice=/media/card-internal'

symlinks_to_update[0]='/usr/bin/psplash=psplash.bat60'			

mount - / -o remount,rw			

# Files kopieren			

for index in "${!files_to_update[@]}" ; do
	
	file=$(echo ${files_to_update[$index]} | sed -e "s/\(.*\)=.*/\1/g")
	dest=$(echo ${files_to_update[$index]} | sed -e "s/.*=\(.*\)/\1/g")
	
	if [ -e "$SERVICE_FILES_DIR"/"$file" ] ; then
		bat_log "Copying $file to $dest" 
		cp -Rf "$SERVICE_FILES_DIR"/"$file" "$dest"	
	fi
done

# Symlinks setzen

for index in "${!symlinks_to_update[@]}" ; do
	
	link=$(echo ${files_to_update[$index]} | sed -e "s/\(.*\)=.*/\1/g")
	dest=$(echo ${files_to_update[$index]} | sed -e "s/.*=\(.*\)/\1/g")
	
	bat_log "Setting symlink $link to $dest" 
	ln -sf "$dest" "$link"	
done

rm -f "$INTERNAL_SD/toggle"

mount - / -o remount,ro	