/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~Seitenspezifisch~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/		
	
//Init-Param
var g_currentState = [];
var g_CurrentFlightModeObj = {};
g_CurrentFlightModeObj.Index = g_CurrentFlightMode;
g_CurrentFlightModeObj.Name = "";
var g_TriggerState = [];
//Init-Param end
	
initPage();
	
function initPage(){
//Alte XML Daten beschaffen
	InitDataPostArgs = getCurrentModelName(InitDataPostArgs);
	GetTd(getFlightModeObject(InitDataPostArgs), g_InitEvent);
//XML Daten Ende	

//Current Flight Mode
	TdPostArgs = getCurrentFlightMode(TdPostArgs)
//Current Flight Mode Ende
	
//Current Flight Mode object
	g_isAdditionalControlObjectUsed = true;
	TdPostArgs = getCurrentFlightModeObject(TdPostArgs)
//Current Flight Mode object Ende

	setInterval(JsonFunction, 250);
	
	drawCombinationTree([0,0,0,0,0], [0,0,0,0,0,0,0,0,0], 0);
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~JSON-Object constructor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
//create and returns FlightMode object
function getFlightModeObject(InitDataPostArgs){
	if(typeof InitDataPostArgs == "undefined")
		InitDataPostArgs = new Object();
	
	FlightMode = new Object();
	FlightMode.Items = "ALL_USED";
	
	Item = new Object();
	Item.Index = 0;
	Item.Name = "";
	flightModeItems = new Array(Item);
	FlightMode.Item = flightModeItems;
		
	Controls = new Object();
	Controls.Control = 0;
	Controls.Trigger = 0;
	controls = new Array(Controls);
	FlightMode.Controls = controls;
	
	FlightMode.ItemCount = 0;
		
	InitDataPostArgs.FlightMode = FlightMode;
	
	return InitDataPostArgs;	
}

//create and returns current FlightMode object
function getCurrentFlightModeObject(TdPostArgs){
	if(typeof TdPostArgs == "undefined"){
		TdPostArgs = new Object();
	}

	FlightMode = new Object();
	
	Current = new Object();
	Current.State = [];
	Current.Combination = [];
	Current.MasterAStr = "";
	Current.MasterAIdx = -1;
	Current.MasterBStr = "";
	Current.MasterBIdx = -1;
	Current.CombinationStr = "";
	Current.CombinationIdx = 0;
	
	FlightMode.Current = Current;

	TdPostArgs.FlightMode = FlightMode;
	
	return TdPostArgs;	
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~EVENT-Handler~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
//EVENT-Handler INIT
function onEVENT_INIT(e){
	try{
		checkHTMLHeader('Model_Name');
		setHTML('Model_Name', e.EventData.ModelName);
		
		controlMasterA = e.EventData.FlightMode.Controls[0].Control;
		controlMasterB = e.EventData.FlightMode.Controls[1].Control;
		controlCombi1  = e.EventData.FlightMode.Controls[2].Control;
		controlCombi2  = e.EventData.FlightMode.Controls[3].Control;
		controlCombi3  = e.EventData.FlightMode.Controls[4].Control;
		
		control2image("Master_A_Control", controlMasterA);
		control2image("Master_B_Control", controlMasterB);
		control2image("Combi_1_Control", controlCombi1);
		control2image("Combi_2_Control", controlCombi2);
		control2image("Combi_3_Control", controlCombi3);
		
		
		triggerMasterA = e.EventData.FlightMode.Controls[0].Trigger;
		triggerMasterB = e.EventData.FlightMode.Controls[1].Trigger;
		triggerCombi1  = e.EventData.FlightMode.Controls[2].Trigger;
		triggerCombi2  = e.EventData.FlightMode.Controls[3].Trigger;
		triggerCombi3  = e.EventData.FlightMode.Controls[4].Trigger;
		
		setTriggerState("Master_A_Trigger", triggerMasterA);
		setTriggerState("Master_B_Trigger", triggerMasterB);
		setTriggerState("Combi_1_Trigger", triggerCombi1);
		setTriggerState("Combi_2_Trigger", triggerCombi2);
		setTriggerState("Combi_3_Trigger", triggerCombi3);
	
		//Listener popupList
		$("#Master_A_Name").bind("click", function(){showPopupList(this, e.EventData.FlightMode.Item, false, true, g_popupList_Indices);});
		$("#Master_B_Name").bind("click", function(){showPopupList(this, e.EventData.FlightMode.Item, false, true, g_popupList_Indices);});
		$("#Combination_Name").bind("click", function(){showPopupList(this, e.EventData.FlightMode.Item, false, true, g_popupList_Indices);});
		
		//Listener Control Assignment
		$('#Master_A_Control').bind("click", function(){window.location.href = "9.1.0__ControlAssignment.html" +
				"?LastURL=" + location.href + 
				"&ControlPath=" + getControlAssignmentPath(controlMasterA, triggerMasterA, 0) + 
				"&ControlId=" + controlMasterA +
				"&ControlTrigger=" + triggerMasterA +
				"&ControlNode=Control" +
				"&ControlNodeTrigger=Trigger" +
				"&PageId=10" +
				"&FromName=Flight Mode Assignment" + 
				"&FromNameSub=Master A"
		});
		
		$('#Master_B_Control').bind("click", function(){window.location.href = "9.1.0__ControlAssignment.html" +
				"?LastURL=" + location.href + 
				"&ControlPath=" + getControlAssignmentPath(controlMasterB, triggerMasterB, 1) + 
				"&ControlId=" + controlMasterB +
				"&ControlTrigger=" + triggerMasterB +
				"&ControlNode=Control" +
				"&ControlNodeTrigger=Trigger" +
				"&PageId=10" +
				"&FromName=Flight Mode Assignment" +
				"&FromNameSub=Master B"
		});
		
		$('#Combi_1_Control').bind("click", function(){window.location.href = "9.1.0__ControlAssignment.html" + 
				"?LastURL=" + location.href + 
				"&ControlPath=" + getControlAssignmentPath(controlCombi1, triggerCombi1, 2) +
				"&ControlId=" + controlCombi1 +
				"&ControlTrigger=" + triggerCombi1 +
				"&ControlNode=Control" +
				"&ControlNodeTrigger=Trigger" +
				"&PageId=10" +
				"&FromName=Flight Mode Assignment" +
				"&FromNameSub=Combi 1"
		});
		
		$('#Combi_2_Control').bind("click", function(){window.location.href = "9.1.0__ControlAssignment.html" +
				"?LastURL=" + location.href + 
				"&ControlPath=" + getControlAssignmentPath(controlCombi2, triggerCombi2, 3) +
				"&ControlId=" + controlCombi2 +
				"&ControlTrigger=" + triggerCombi2 +
				"&ControlNode=Control" +
				"&ControlNodeTrigger=Trigger" +
				"&PageId=10" +
				"&FromName=Flight Mode Assignment" +
				"&FromNameSub=Combi 2"
		});
		
		$('#Combi_3_Control').bind("click", function(){window.location.href = "9.1.0__ControlAssignment.html" + 
				"?LastURL=" + location.href + 
				"&ControlPath=" + getControlAssignmentPath(controlCombi3, triggerCombi3, 4) +
				"&ControlId=" + controlCombi3 +
				"&ControlTrigger=" + triggerCombi3 +
				"&ControlNode=Control" +
				"&ControlNodeTrigger=Trigger" +
				"&PageId=10" +
				"&FromName=Flight Mode Assignment" +
				"&FromNameSub=Combi 3"
		});
	}catch(err){
		onError(err, "Error Init: ", false);
	}
}

//EVENT-Handler CONTROL/TELEMETRY Intervaldata
function handleEventControl(cmd, e, key, value, valueStr){
	//Flightmode
	g_currentState = e.EventData.FlightMode.Current.State;
		
	if(typeof preStateMasterA == "undefined"){
		preStateMasterA = -1;
	}

	if(typeof preStateMasterB == "undefined"){
		preStateMasterB = -1;
	}
		
	currentFM = e.EventData.Current_FM.Index;

	if((preStateMasterA != g_currentState[0]) || (preStateMasterB != g_currentState[1])){
		$('#' + g_CurrentFlightModeObj.Name).removeClass('active_fm');

		if(g_currentState[0] == 1){
			g_CurrentFlightModeObj.Name = 'Master_A_Row';
		}
		else if(g_currentState[1] == 1){
			g_CurrentFlightModeObj.Name = 'Master_B_Row';
		}
		else{
			g_CurrentFlightModeObj.Name = 'Combi_Row';
		}

		$('#' + g_CurrentFlightModeObj.Name).addClass('active_fm');
		g_CurrentFlightModeObj.Index = currentFM;
	}
		
	setHTML("Master_A_Name", e.EventData.FlightMode.Current.MasterAStr);
	g_popupList_Indices["Master_A_Name"] = e.EventData.FlightMode.Current.MasterAIdx;
	setHTML("Master_B_Name", e.EventData.FlightMode.Current.MasterBStr);
	g_popupList_Indices["Master_B_Name"] = e.EventData.FlightMode.Current.MasterBIdx;
	setHTML("Combination_Name", e.EventData.FlightMode.Current.CombinationStr);
	g_popupList_Indices["Combination_Name"] = e.EventData.FlightMode.Current.CombinationIdx;

	//Master A State
	if(preStateMasterA != g_currentState[0]){
		state2image("Master_A_State", g_currentState[0]);
		trigger2image("Master_A_Trigger", g_currentState[0]);
		preStateMasterA = g_currentState[0];
	}
		
	//Master B State
	if(preStateMasterB != g_currentState[1]){
		state2image("Master_B_State", g_currentState[1]);
		trigger2image("Master_B_Trigger", g_currentState[1]);
		preStateMasterB = g_currentState[1];
	}
		
	//Combo 1 State
	if(typeof preStateCombi1== "undefined"){
		preStateCombi1 = -1;
	}

	if(preStateCombi1 != g_currentState[2]){
		state2image("Combi_1_State", g_currentState[2]);
		trigger2image("Combi_1_Trigger", g_currentState[2]);
		preStateCombi1 = g_currentState[2];
	}
		
	//Combo 2 State
	if(typeof preStateCombi2== "undefined"){
		preStateCombi2 = -1;
	}

	if(preStateCombi2 != g_currentState[3]){
		state2image("Combi_2_State", g_currentState[3]);
		trigger2image("Combi_2_Trigger", g_currentState[3]);
		preStateCombi2 = g_currentState[3];
	}
		
	//Combo 3 State
	if(typeof preStateCombi3== "undefined"){
		preStateCombi3 = -1;
	}

	if(preStateCombi3 != g_currentState[4]){
		state2image("Combi_3_State", g_currentState[4]);
		trigger2image("Combi_3_Trigger", g_currentState[4]);
		preStateCombi3 = g_currentState[4];
	}

	g_currentCombination = e.EventData.FlightMode.Current.Combination;

	updateCombinationTree(g_currentState, g_currentCombination, g_CurrentFlightModeObj.Name);
}

//EVENT-Handler Setdata
function onEVENT_SET(e){
	try{
		
	}catch(err){
		onError(err, "Error Setdata: ", false);
	}	
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~Set Function~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/		
function getControlAssignmentPath(control, trigger, Index){
	cmd = "set";
	ModelName = "model-settings";
	str = encodeURI('{"' + cmd + '":{"' + ModelName + '":{"FMControlAssign":{"ControlSwitch":{"Control":' + control + ',"Trigger":' + trigger +',"Index":' + Index + '}}}}}'); 

	return str;
}

function getPathObj(cmd, ModelName){
	xmlObj = {};
	xmlObj[cmd] = {};
	xmlObj[cmd][ModelName] = {};

	return xmlObj;
}

function submitSET(tagId, value){
	cmd = "set";
	ModelName = "model-settings";
	Type = "FlightMode";

	if(tagId == "Master_A_Name"){
		g_currentState[0] = 1;		
	}
	else{
		g_currentState[0] = 0;
		if(tagId == "Master_B_Name"){
			g_currentState[1] = 1;
		}
		else if(tagId == "Combination_Name"){
			g_currentState[1] = 0;
		}
	}

	xmlObj = getPathObj(cmd, ModelName);
	xmlObj[cmd][ModelName] = {};
	xmlObj[cmd][ModelName]["FMControlAssign"] = {};
	xmlObj[cmd][ModelName]["FMControlAssign"][Type] = {};
	xmlObj[cmd][ModelName]["FMControlAssign"][Type]["Index"] = parseInt(value);
	xmlObj[cmd][ModelName]["FMControlAssign"][Type]["State"] = g_currentState;

	GetTd(xmlObj, g_SetEvent, cmd);
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~Specific Function~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
//Converts a state to an control-image shown in the lists
function state2image(id, state){
	switch(state){	
		case 0:	/* state off (0) --> sw_off.png*/	setHTML_Attribute(id, "src", "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEcAAAA3CAYAAABeklfeAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAT3SURBVHja7Fp7iFRVHD6ji5qo62pbaT62EltUtDQfoZYPFAtRsxTEB2r/REbkY8UXqRFWZqv4flG0QSUqFYiS70wtfIGWsZAlRroqqZurLprb9P3Yb+js5c7cc+/MnTtw7w8+5sy9vzPn3O+c83vdicXjcaVLeXm5CkAeBYYCBcAfwD7gRrYnUVxcXOd7ngpWGgAfAq9b5nILeBtYHuTkgibnS+Alm+tNgFKgObAwqMnVC5CYF5IQo8t8oCiM5Ewx0KkPTAgjOU8Y6nUMIzlVhnq3wkjO94Z6R8NIziEDnQvA1jCSs8Dh/nVgLHA3bOSMAZ5Lcq8CWA10A46FLQhsxKjYKveBHsAZlSMSxM4pAdrbXF+XS8QEQY4kmHNsrl8DFqsck2yTsxRobHN9IQkKLTl9gHE2138GNqgclHpZHGcVELO5N53GOLTkTASesbn+NbBX5ahk0pX3Akbz+OQDA4FKoCnwvo2+BHezPIzTkOUO+X0p3bUEqoHfmWp8BVzNFXIkNlkB9LMclUq25wGP2PSTKt9vLsaR8sU0/t7DNvdl/EnASmANsAT4K50Hi6VZQ55OD6STfBroCfwDPA78wtXW5TLwJHDTcBwhYzvQ13K9khF1PnXqW8aQYtqPpg9jrSGnY3MkXinViNnCyXcnMSIf2RCT6GtKTCGT1L5aCWORqq3zSEG+E+MnIWcq8Cv1ZLce4BHM6s4ZBuyk97kNjAe+segMTmJsTwC9gX8Nj9JB7cgeZjJa4WAq3tPsWRUX7JzbnePF5jRgXBKjCx4B7Oe9B4BXgAGq9lWLVWQl3tSI6e9Q15E0YwdxD1hP45tK7jNFkZ35Dh3CBi6W7wZZjF47tks1YrrRUzyWou8XwA9sv0zjWaQdQ6uIB/rA46l4F3iepAxiFeCQmx/wYnPG87Nam/hDwG4HYkR/tiUzb82J+yFxbTyRyZnYOdcd+uTzc7em+xYJcrIfieNUpBEpR/Bbnwg6xUy/KwPRUQ76LZzIKTAcWLfcow1t1XBgE/tW0R508jnQPUly8lw8W9quXHdzbQz7tNPaN1wuhle5EnRudclQ77LWbqzFLX5K0yDI0V+27TDQF3uzS9tpD7J9zmdyOmQytxrr0Edym6cYxzRjPLFM1b62LUzR71O6ZsVYKCFHfCSmufq/kH9c2deuXZHj9J5IvJK8HWjC3Goxj5UEg9sYytuVJt5gW/rNYPtvw13nVUoYmIpsVi7fgXk5Vh9rRm4uUwHFBE+8wnw+sKzU5/RQkgDeoZ5k8G3ZXs30I1V5ooBo5nKevbl4CaP8WTYi5Grugq2c/C4+/HeMe5akGEuIeZXfzyep8+giduknklPD1GOtwRy7MlpP7JoZBmlHxgzyNj5owhXvZ/7SOUnw9yITzmnacRpp4KkuMrKt4e+s4aK0T6IvR3YBU5RWvLaOOzir9ZwYV75E1a0NSz3nLI9La1YICy1ufwSDM1MRJ1GmlT9quFPP8MgIKV2AIaru2w2xM69R33U9J5aBP0wO4VZ3cpk1TDxnKm9lTElsPwGeNtCtYM2ozM0Afvxhco+qreUOp4t+lts+jynCWeqUpRnTyI7swfxIKgMDtTwvUao4yQXY6MXGZPJYmRy7uI9uOsawoQVt15+s+XgWx2MVSeZzq4iciJxIInIiciJyInIiciJyInIiciJyInIiichxK/8JMAD5YBAkJJ3urwAAAABJRU5ErkJggg=="); break;
		case 1:	/* state on  (1) --> sw_on.png*/	setHTML_Attribute(id, "src", "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEcAAAA3CAYAAABeklfeAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAYbSURBVHja7JgLUJRVFMf3gYC4bIoIiIEMakCgaaZkRgQV0WQ0Rgw2tjT4ypQ0s6KaKXFqpjANHZ/5gnAKdbOZsCYhiZBMM8sKEHwxGvEUcYTlseDu9j/M2eab1YVlF4hm7pn5z3f3e927v+/ce+45cpPJJBN2e1MIBAKOgCPgCDgCjoAj4Ag4Ao4wAUfAEXAEHAFHwPlfmZPliYqKiv4A7g2NgpqhamggKmpyaBz30wLVQJ2OvDA4OLhnOH21kJAQWXl5+XA0l0AJULjFe29AhdCn0Fe4325Q6IeAPA29AEVBd0gu34ROQQehnVC7w/Qty6R2eE4S9AHka8O9v0ELAOgPO8Dcg8Ne6F4bbicvegvKdsRzHIGjhHZAiyTn2qDvoLM8pXygyVAk30+mhzQApO0DGPLIfZALnzJARVAJVAepobuhxyA3yaO7oaV8/6BOq80SMAQlfe3atZn79+8n1x/BMGgNaM3KylKHh4e/jfbz/Adz8If1AJRrA5g4ul8C99Dp06ff1Wg0N7gfZ/7zrfPmzTOuWbMmGe03GRKNrwtaNpjT6jnoc27X19bWzomOjm7iL2jNmsrKyuIUCsUmXrSvk1e9+mtwtbUHPp5eQVO1lBddI2xFaGjoYbQ9euinuaCgYJSvry/dN5bPzZeMd0CnFS2+lTxl2hsbG2MiIiKukUf4P7rMJ/Cp1AUuaq9wucLJ3djVUdfWcOnInzuTtc2Xz9AC2ZyUlNSlUqmU7BXthYWFemsdRUVFucC7qD+ZTqczZGdnD6MPoA6YNnzKkswEN68JsYphrj4m480WfXPDz5WH0/f+dXQbTTN9cXHxaE9Pz3weL50L7G2R7g84FJU+4XYaBk9rgXraywdnec+MXy+XK9wsHwCky2ezVyytKtxV72gE8Yta7B2i2bRD6Tw8wPKayWRsqzv1xerfNyeepA8B+It4YSZ7kaOYQ3ASehnf69AMqGPr1q1BW7Zs8bgzcoFX2MKdh+QKpcraQ4YOXcn1Cz/tcxTOqEkPaJSuqsnWrpuMBl3pniXxfxftbUhJSWlavnz5OZx2hX6BPuoFjrY3OLbuQ/LgNQtxHBO54eIqN+8JSUNlZ9tWfym7aPXEDDSvwnv24Pi4jdFK3l/pw0Wo21NcRvrMHErbfoxnBjdVPM5Bz6105vCKxVc1lOBQMJDsxVr+Czhe5lzG0NVeM5TgSMbTyePsn8ST9x89mTs/N529R9VaXZ43ctKs3qaWkRZLx72ie9Hv8aO21lTkS7z7Pknu1ScvsieUU35Du1DZlStXwmNjYzud3T2VkRmVmU6u7lajSGvd+V3HXgva5iich9afWzbC567F1q7f7GgpKVoVmNzZ0mjIy8tz8ff3P8mXMimv60sot2daZZkb48ePT3NycmqigZzZ9GwKjkW3xlaTAWB2F6eGbZfkRfZKRu+h99F7Lbvq0l0r4nEYaFwA8/7txj3Q6UMBFM3td3gjSFt8WWjy9skeQRH3K13c1J26a9U1xz8rvnxkY3eKMHXq1NacnJw5nA+RaZE+VPaQPgRyGaQ7YZ07d+5hjK97sQ2IfWWc7+z5Ec6q0eMM+rbmpnPFJ8syXyoxLw0I4Roc3+Pf30OPDFZWPpHLD+aosC4mJmZjVVWVmrfrt0S29PR0eVxc3C7O0Ml+hB4GHEMPcCja/AA9yKeO5ebmLkpNTTWZtxEW1u7n59eSn5+/Eu03JOsOrY/nB7Nk8SRlyJIyAnX+4YEDBwrS0tI6OYzqtVrt2LCwsGfQXi2BeQGaDY+7akNWPgaH49AkPkWL6obS0tIvExISarl/A/p0TkxMJO9IhYIk5ZF46JvBrueQzWJAY6WRFKriL2YuY0qN/mg8wNicZwGQN/cz+zaRtZq9yE9S1pBxskkf5YS9xS5HC+zU8RQoQ1K/pQFSUhhmAaYBWkXTqi9guBRbz9NxJb/n31SL+wmQgKFxbOQi2wlH/pzDZVKqIfPX9eCpFsUeM5pqOHSJa8jf4l69o6Ec/dA0eoL7CeHaDr33EnQU+pr77bP1Oq2E9d+0EnAEHGECjoAj4Ag4Ao6AI+AIOAKOMAFHwBFwBsD+EWAA3LlcXJInXFYAAAAASUVORK5CYII=");  break;
	}
}

//Converts a state from a switch to an trigger-image.
function trigger2image(id, state){
//	$('#' + id).removeClass(g_TriggerState[id][state^1]);
//	$('#' + id).addClass(g_TriggerState[id][state]);
	$('#' + id).addClass(g_TriggerState[id][0]);
}

//Set Trigger States
function setTriggerState(tagId, trigger){
	var triggerArray = new Array();
	
	switch(trigger){
		case 	  512:  triggerArray[0] = "icon_trigger_p25_white";
						triggerArray[1] = "icon_trigger_p25_blue";
						break;
		case 	 -512:  triggerArray[0] = "icon_trigger_m25_white";
						triggerArray[1] = "icon_trigger_m25_blue";
						break;
		case 	 1536:  triggerArray[0] = "icon_trigger_p75_white";
						triggerArray[1] = "icon_trigger_p75_blue";
						break;
		case 	-1536:  triggerArray[0] = "icon_trigger_m75_white";
						triggerArray[1] = "icon_trigger_m75_blue";
						break;
		default:		triggerArray[0] = "icon_trigger_empty";
						triggerArray[1] = "icon_trigger_empty";
	}

	g_TriggerState[tagId] = triggerArray;
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~Canvas~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
function drawCombinationTree(states, combinations, active_fm){
	black = "#000";
	blue  = "#1488ff";
	grey  = "#aaa";
	white = "#fff";
	
	W = 240;
    H = 309;

	tree = Raphael("Combination_Canvas", W, H);
    
    log(3, 'States: ' + states + '\nCombinations: ' + combinations + '\nActive-FM: ' + active_fm);
   
    node_radius = 2;
    combi_radius = 7;
    
    line_width_thin  = "2px";
    line_width_thick = "5px";
    
    /* Init Tree Start */
    /* Nodes Start */
    node0 = tree.circle(120,  13, node_radius).attr({fill: grey, "stroke-width": 0});	//Master A
    node1 = tree.circle(120,  75, node_radius).attr({fill: grey, "stroke-width": 0});	//Master B
    node2 = tree.circle(120, 137, node_radius).attr({fill: grey, "stroke-width": 0});	//Combi 1 Top
    node3 = tree.circle( 60, 155, node_radius).attr({fill: grey, "stroke-width": 0});	//Combi 1 Left
    node4 = tree.circle(180, 155, node_radius).attr({fill: grey, "stroke-width": 0});	//Combi 1 Right
    node5 = tree.circle( 30, 217, node_radius).attr({fill: grey, "stroke-width": 0});	//Combi 2 Left
    node6 = tree.circle( 90, 217, node_radius).attr({fill: grey, "stroke-width": 0});	//Combi 2 Left Center
    node7 = tree.circle(150, 217, node_radius).attr({fill: grey, "stroke-width": 0});	//Combi 2 Right Center
    node8 = tree.circle(210, 217, node_radius).attr({fill: grey, "stroke-width": 0});	//Combi 2 Right
    /* Nodes End */
    /* Circels Starts */
    if(combinations[9] == 1)
    	circle0  = tree.circle( 82,  30, combi_radius).attr({fill: grey, stroke: grey, "stroke-width": "3px"});
	else
		circle0  = tree.circle( 82,  30, combi_radius).attr({stroke: grey, "stroke-width": "3px"});
    
    if(combinations[8] == 1)
		circle1  = tree.circle( 82,  92, combi_radius).attr({fill: grey, stroke: grey, "stroke-width": "3px"});
	else
		circle1  = tree.circle( 82,  92, combi_radius).attr({stroke: grey, "stroke-width": "3px"});
    
    if(combinations[7] == 1)
		circle2  = tree.circle( 15, 278, combi_radius).attr({fill: grey, stroke: grey, "stroke-width": "3px"});
	else
		circle2  = tree.circle( 15, 278, combi_radius).attr({stroke: grey, "stroke-width": "3px"});
	
	if(combinations[6] == 1)
		circle3  = tree.circle( 45, 278, combi_radius).attr({fill: grey, stroke: grey, "stroke-width": "3px"});
	else
		circle3  = tree.circle( 45, 278, combi_radius).attr({stroke: grey, "stroke-width": "3px"});
	
	if(combinations[5] == 1)
		circle4  = tree.circle( 75, 278, combi_radius).attr({fill: grey, stroke: grey, "stroke-width": "3px"});
	else
		circle4  = tree.circle( 75, 278, combi_radius).attr({stroke: grey, "stroke-width": "3px"});
	
	if(combinations[4] == 1)
		circle5  = tree.circle(105, 278, combi_radius).attr({fill: grey, stroke: grey, "stroke-width": "3px"});
	else
		circle5  = tree.circle(105, 278, combi_radius).attr({stroke: grey, "stroke-width": "3px"});
	
	if(combinations[3] == 1)
		circle6  = tree.circle(135, 278, combi_radius).attr({fill: grey, stroke: grey, "stroke-width": "3px"});
	else
		circle6  = tree.circle(135, 278, combi_radius).attr({stroke: grey, "stroke-width": "3px"});
	
	if(combinations[2] == 1)
		circle7  = tree.circle(165, 278, combi_radius).attr({fill: grey, stroke: grey, "stroke-width": "3px"});
	else
		circle7  = tree.circle(165, 278, combi_radius).attr({stroke: grey, "stroke-width": "3px"});
	
	if(combinations[1] == 1)
		circle8  = tree.circle(195, 278, combi_radius).attr({fill: grey, stroke: grey, "stroke-width": "3px"});
	else
		circle8  = tree.circle(195, 278, combi_radius).attr({stroke: grey, "stroke-width": "3px"});
	
	if(combinations[0] == 1)
		circle9 = tree.circle(225, 278, combi_radius).attr({fill: grey, stroke: grey, "stroke-width": "3px"});
	else
		circle9 = tree.circle(225, 278, combi_radius).attr({stroke: grey, "stroke-width": "3px"});
	/* Circels End */
	/* Lines Start */
	if(states[0] == 1)
		line0 = tree.path("M91 26L117 14.5").attr({fill: grey, stroke: grey, "stroke-width": line_width_thick});	//Master A
	else
		line0 = tree.path("M91 26L117 14.5").attr({fill: grey, stroke: grey, "stroke-width": line_width_thin});		//Master A
	
	line1 = tree.path("M120 17L120 71").attr({fill: grey, stroke: grey, "stroke-width": line_width_thick});			//Master A -- Master B
	
	if(states[1] == 1)
		line2 = tree.path("M91 88L117 76.5").attr({fill: grey, stroke: grey, "stroke-width": line_width_thick});	//Master B
	else
		line2 = tree.path("M91 88L117 76.5").attr({fill: grey, stroke: grey, "stroke-width": line_width_thin});		//Master B
	
	line3 = tree.path("M120 79L120 133").attr({fill: grey, stroke: grey, "stroke-width": line_width_thick});		//Master B -- Combi 1
	
	if(states[2] == 1){
		line4 = tree.path("M63 154L117 138").attr({fill: grey, stroke: grey, "stroke-width": line_width_thick});	//Combi 1 -- Left
		line5 = tree.path("M177 154L123 138").attr({fill: grey, stroke: grey, "stroke-width": line_width_thin});	//Combi 1 -- Right
	}
	else{
		line4 = tree.path("M63 154L117 138").attr({fill: grey, stroke: grey, "stroke-width": line_width_thin});		//Combi 1 -- Left
		line5 = tree.path("M177 154L123 138").attr({fill: grey, stroke: grey, "stroke-width": line_width_thick});	//Combi 1 -- Right
	}
	
	if(states[2] == 1 && states[3] == 1)
		line6 = tree.path("M31 214L58.5 158").attr({fill: grey, stroke: grey, "stroke-width": line_width_thick});	//Combi 1 Left -- Combi 2 Left
	else
		line6 = tree.path("M31 214L58.5 158").attr({fill: grey, stroke: grey, "stroke-width": line_width_thin});	//Combi 1 Left -- Combi 2 Left
	
	if(states[2] == 1 && states[3] == 0)
		line7 = tree.path("M89 214L61.5 158").attr({fill: grey, stroke: grey, "stroke-width": line_width_thick});	//Combi 1 Left -- Combi 2 Left Center
	else
		line7 = tree.path("M89 214L61.5 158").attr({fill: grey, stroke: grey, "stroke-width": line_width_thin});	//Combi 1 Left -- Combi 2 Left Center
	
	if(states[2] == 0 && states[3] == 1)
		line8 = tree.path("M151 214L178.5 158").attr({fill: grey, stroke: grey, "stroke-width": line_width_thick});	//Combi 1 Right -- Combi 2 Right Center
	else
		line8 = tree.path("M151 214L178.5 158").attr({fill: grey, stroke: grey, "stroke-width": line_width_thin});	//Combi 1 Right -- Combi 2 Right Center
	
	if(states[2] == 0 && states[3] == 0)
		line9 = tree.path("M209 214L181.5 158").attr({fill: grey, stroke: grey, "stroke-width": line_width_thick});	//Combi 1 Right -- Combi 2 Right
	else
		line9 = tree.path("M209 214L181.5 158").attr({fill: grey, stroke: grey, "stroke-width": line_width_thin});	//Combi 1 Right -- Combi 2 Right
	
	if(states[2] == 1 && states[3] == 1 && states[4] == 1)
		line10 = tree.path("M17 268.5L29 220").attr({fill: grey, stroke: grey, "stroke-width": line_width_thick});	//Combi 2 Left -- Combi 3 #1
	else
		line10 = tree.path("M17 268.5L29 220").attr({fill: grey, stroke: grey, "stroke-width": line_width_thin});	//Combi 2 Left -- Combi 3 #1
	
	if(states[2] == 1 && states[3] == 1 && states[4] == 0)
		line11 = tree.path("M44 268.5L31 220").attr({fill: grey, stroke: grey, "stroke-width": line_width_thick});	//Combi 2 Left -- Combi 3 #2
	else
		line11 = tree.path("M44 268.5L31 220").attr({fill: grey, stroke: grey, "stroke-width": line_width_thin});	//Combi 2 Left -- Combi 3 #2
	
	if(states[2] == 1 && states[3] == 0 && states[4] == 1)
		line12 = tree.path("M77 268.5L89 220").attr({fill: grey, stroke: grey, "stroke-width": line_width_thick});	//Combi 2 Left -- Combi 3 #3
	else
		line12 = tree.path("M77 268.5L89 220").attr({fill: grey, stroke: grey, "stroke-width": line_width_thin});	//Combi 2 Left -- Combi 3 #3
	
	if(states[2] == 1 && states[3] == 0 && states[4] == 0)
		line13 = tree.path("M104 268.5L91 220").attr({fill: grey, stroke: grey, "stroke-width": line_width_thick});	//Combi 2 Left -- Combi 3 #4
	else
		line13 = tree.path("M104 268.5L91 220").attr({fill: grey, stroke: grey, "stroke-width": line_width_thin});	//Combi 2 Left -- Combi 3 #4
	
	if(states[2] == 0 && states[3] == 1 && states[4] == 1)
		line14 = tree.path("M137 268.5L149 220").attr({fill: grey, stroke: grey, "stroke-width": line_width_thick});//Combi 2 Left -- Combi 3 #5
	else
		line14 = tree.path("M137 268.5L149 220").attr({fill: grey, stroke: grey, "stroke-width": line_width_thin});	//Combi 2 Left -- Combi 3 #5
	
	if(states[2] == 0 && states[3] == 1 && states[4] == 0)
		line15 = tree.path("M164 268.5L151 220").attr({fill: grey, stroke: grey, "stroke-width": line_width_thick});//Combi 2 Left -- Combi 3 #6
	else
		line15 = tree.path("M164 268.5L151 220").attr({fill: grey, stroke: grey, "stroke-width": line_width_thin});	//Combi 2 Left -- Combi 3 #6
	
	if(states[2] == 0 && states[3] == 0 && states[4] == 1)
		line16 = tree.path("M197 268.5L209 220").attr({fill: grey, stroke: grey, "stroke-width": line_width_thick});//Combi 2 Left -- Combi 3 #7
	else
		line16 = tree.path("M197 268.5L209 220").attr({fill: grey, stroke: grey, "stroke-width": line_width_thin});	//Combi 2 Left -- Combi 3 #7
	
	if(states[2] == 0 && states[3] == 0 && states[4] == 0)
		line17 = tree.path("M224 268.5L211 220").attr({fill: grey, stroke: grey, "stroke-width": line_width_thick});//Combi 2 Left -- Combi 3 #8
	else
		line17 = tree.path("M224 268.5L211 220").attr({fill: grey, stroke: grey, "stroke-width": line_width_thin});	//Combi 2 Left -- Combi 3 #8
	/* Lines End */
	
	/* Highlight Start */
	if(active_fm == 'Combi_Row'){
		node0.attr({fill: white});
		node1.attr({fill: white});
		node2.attr({fill: white});
		
		line1.attr({fill: white, stroke: white});
		line3.attr({fill: white, stroke: white});
		if(states[2] == 1 && states[3] == 1 && states[4] == 1){
			node3.attr({fill: white});
			node5.attr({fill: white});
			line4.attr({fill: white, stroke: white});
			line6.attr({fill: white, stroke: white});
			line10.attr({fill: white, stroke: white});
			
			if(combinations[7] == 1)
				circle2.attr({fill: blue});

			circle2.attr({stroke: blue});
		}
		else if(states[2] == 1 && states[3] == 1 && states[4] == 0){
			node3.attr({fill: white});
			node5.attr({fill: white});
			line4.attr({fill: white, stroke: white});
			line6.attr({fill: white, stroke: white});
			line11.attr({fill: white, stroke: white});
			
			if(combinations[6] == 1)
				circle3.attr({fill: blue});

			circle3.attr({stroke: blue});
		}
		else if(states[2] == 1 && states[3] == 0 && states[4] == 1){
			node3.attr({fill: white});
			node6.attr({fill: white});
			line4.attr({fill: white, stroke: white});
			line7.attr({fill: white, stroke: white});
			line12.attr({fill: white, stroke: white});
			
			if(combinations[5] == 1)
				circle4.attr({fill: blue});

			circle4.attr({stroke: blue});
		}
		else if(states[2] == 1 && states[3] == 0 && states[4] == 0){
			node3.attr({fill: white});
			node6.attr({fill: white});
			line4.attr({fill: white, stroke: white});
			line7.attr({fill: white, stroke: white});
			line13.attr({fill: white, stroke: white});
			
			if(combinations[4] == 1)
				circle5.attr({fill: blue});

			circle5.attr({stroke: blue});
		}
		else if(states[2] == 0 && states[3] == 1 && states[4] == 1){
			node4.attr({fill: white});
			node7.attr({fill: white});
			line5.attr({fill: white, stroke: white});
			line8.attr({fill: white, stroke: white});
			line14.attr({fill: white, stroke: white});
			
			if(combinations[3] == 1)
				circle6.attr({fill: blue});

			circle6.attr({stroke: blue});
		}
		else if(states[2] == 0 && states[3] == 1 && states[4] == 0){
			node4.attr({fill: white});
			node7.attr({fill: white});
			line5.attr({fill: white, stroke: white});
			line8.attr({fill: white, stroke: white});
			line15.attr({fill: white, stroke: white});
			
			if(combinations[2] == 1)
				circle7.attr({fill: blue});

			circle7.attr({stroke: blue});
		}
		else if(states[2] == 0 && states[3] == 0 && states[4] == 1){
			node4.attr({fill: white});
			node8.attr({fill: white});
			line5.attr({fill: white, stroke: white});
			line9.attr({fill: white, stroke: white});
			line16.attr({fill: white, stroke: white});
			
			if(combinations[1] == 1)
				circle8.attr({fill: blue});

			circle8.attr({stroke: blue});
		}
		else if(states[2] == 0 && states[3] == 0 && states[4] == 0){
			node4.attr({fill: white});
			node8.attr({fill: white});
			line5.attr({fill: white, stroke: white});
			line9.attr({fill: white, stroke: white});
			line17.attr({fill: white, stroke: white});
			
			if(combinations[0] == 1)
				circle9.attr({fill: blue});

			circle9.attr({stroke: blue});
		}
	}
	else if(active_fm == 'Master_B_Row'){
		node0.attr({fill: white});
		node1.attr({fill: white});
		
		line1.attr({fill: white, stroke: white});
		line2.attr({fill: white, stroke: white});
		
		if(combinations[8] == 1)
			circle1.attr({fill: blue});

		circle1.attr({stroke: blue});
	}
	else if(active_fm == 'Master_A_Row'){
		node0.attr({fill: white});
		
		line0.attr({fill: white, stroke: white});
		
		if(combinations[9] == 1)
			circle0.attr({fill: blue});
		
		circle0.attr({stroke: blue});
	}
	/* Highlight End */
	
	if(navigator.appVersion.indexOf("X11; U; Linux armv7l; c") != -1){
		var h1 = "123.5";
		var h2 = "61.5";
	}
	else{
		var h1 = "124.5";
		var h2 = "62.5";
	}

	line_black_1 = tree.path("M117 " + h1 + "H123").attr({fill: black, stroke: black, "stroke-width": "1px"});
	line_black_2 = tree.path("M117 " + h2 + "H123").attr({fill: black, stroke: black, "stroke-width": "1px"});
}


function updateCombinationTree(states, combinations, active_fm){
	tree.remove();
	drawCombinationTree(states, combinations, active_fm);	
}
