/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~Seitenspezifisch~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
var g_controlIDBeep = -1;
var g_controlIDVario = -1;
var g_controlIDVoice = -1;
var g_controlIDLight = -1;
initPage();

function initPage(){
	$('#Soft_Shutdown').bind('click', function(){shutDown();});
	
//Alte XML Daten beschaffen
	InitDataPostArgs = getNumPadLimitObj(InitDataPostArgs, "Brightness");
	InitDataPostArgs = getNumPadLimitObj(InitDataPostArgs, "Control");
	GetTd(getNumPadLimitObj(InitDataPostArgs, "Control_Positiv"),g_InitEvent);
	GetTd(getGeneralSettingsObject(InitDataPostArgs), g_InitEvent, "get");
//XML Daten Ende	
	
	g_isAdditionalControlObjectUsed = true;
	TdPostArgs = getCurrentGeneralSettingsObject(TdPostArgs);
	setInterval(JsonFunction, 250);
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~JSON-Object constructor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
//create and returns Servo object
function getGeneralSettingsObject(InitDataPostArgs){
	if(typeof InitDataPostArgs == "undefined"){
		InitDataPostArgs = new Object();
	}
	
	volumeBeep = new Object();
	volumeBeep.Hi = "";
	volumeBeep.Center = "";
	volumeBeep.Lo = "";
	volumeBeep.ControlID = g_controlIDBeep;
	
	volumeVario = new Object();
	volumeVario.Hi = "";
	volumeVario.Center = "";
	volumeVario.Lo = "";
	volumeVario.ControlID = g_controlIDVario;
	
	volumeVoice = new Object();
	volumeVoice.Hi = "";
	volumeVoice.Center = "";
	volumeVoice.Lo = "";
	volumeVoice.ControlID = g_controlIDVoice;
	
	
	brightness = new Object();
	brightness.Hi = "";
	brightness.Center = "";
	brightness.Lo = "";
	brightness.ControlID = g_controlIDLight;
	
	InitDataPostArgs["get"] = {};
	InitDataPostArgs["get"]["general-settings"] = {};
	InitDataPostArgs["get"]["general-settings"]["GeneralSettingsHK"] = {};
	InitDataPostArgs["get"]["general-settings"]["GeneralSettingsHK"]["VolumeBeep"] = volumeBeep;
	InitDataPostArgs["get"]["general-settings"]["GeneralSettingsHK"]["VolumeVario"] = volumeVario;
	InitDataPostArgs["get"]["general-settings"]["GeneralSoundConfig"] = {};
	InitDataPostArgs["get"]["general-settings"]["GeneralSoundConfig"]["VolumeVoice"] = volumeVoice;
	InitDataPostArgs["get"]["general-settings"]["Brightness"] = brightness;
	
	return InitDataPostArgs;
}

function getCurrentGeneralSettingsObject(TdPostArgs){
	if(typeof TdPostArgs == "undefined"){
		TdPostArgs = new Object();
	}
	
	volumeBeep = new Object();
	volumeBeep.Current = "";
	
	volumeVario = new Object();
	volumeVario.Current = "";
	
	volumeVoice = new Object();
	volumeVoice.Current = "";
	
	brightness = new Object();
	brightness.Current = "";
	
	TdPostArgs["general-settings"] = {};
	TdPostArgs["general-settings"]["GeneralSettingsHK"] = {};
	TdPostArgs["general-settings"]["GeneralSettingsHK"]["VolumeBeep"] = volumeBeep;
	TdPostArgs["general-settings"]["GeneralSettingsHK"]["VolumeVario"] = volumeVario;
	TdPostArgs["general-settings"]["GeneralSoundConfig"] = {};
	TdPostArgs["general-settings"]["GeneralSoundConfig"]["VolumeVoice"] = volumeVoice;
	TdPostArgs["general-settings"]["Brightness"] = brightness;
	
	return TdPostArgs;
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~EVENT-Handler~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
//EVENT-Handler INIT
function onEVENT_INIT(e){
	try{
		if(e.cmd=="get"){
			setHTML('General_Volume_High_Value', e.EventData.get.GeneralSettingsHK.VolumeBeep.Hi);
			setHTML('General_Volume_Center_Value', e.EventData.get.GeneralSettingsHK.VolumeBeep.Center);
			setHTML('General_Volume_Low_Value', e.EventData.get.GeneralSettingsHK.VolumeBeep.Lo);
			
			setHTML('Vario_Offset_High_Value', e.EventData.get.GeneralSettingsHK.VolumeVario.Hi);
			setHTML('Vario_Offset_Center_Value', e.EventData.get.GeneralSettingsHK.VolumeVario.Center);
			setHTML('Vario_Offset_Low_Value', e.EventData.get.GeneralSettingsHK.VolumeVario.Lo);
			
			setHTML('Voice_Offset_High_Value', e.EventData.get.GeneralSoundConfig.VolumeVoice.Hi);
			setHTML('Voice_Offset_Center_Value', e.EventData.get.GeneralSoundConfig.VolumeVoice.Center);
			setHTML('Voice_Offset_Low_Value', e.EventData.get.GeneralSoundConfig.VolumeVoice.Lo);
			
			setHTML('Display_Brightness_High_Value', e.EventData.get.Brightness.Hi);
			setHTML('Display_Brightness_Center_Value', e.EventData.get.Brightness.Center);
			setHTML('Display_Brightness_Low_Value', e.EventData.get.Brightness.Lo);
			
			g_controlIDBeep = e.EventData.get.GeneralSettingsHK.VolumeBeep.ControlID;
			g_controlIDVario = e.EventData.get.GeneralSettingsHK.VolumeVario.ControlID;
			g_controlIDVoice = e.EventData.get.GeneralSoundConfig.VolumeVoice.ControlID;
			g_controlIDLight = e.EventData.get.Brightness.ControlID;
			
			control2image('General_Volume_Control', g_controlIDBeep);
			control2image('Vario_Offset_Control', g_controlIDVario);
			control2image('Voice_Offset_Control', g_controlIDVoice);
			control2image('Display_Brightness_Control', g_controlIDLight);
			
			//Control Assignment
			$('#General_Volume_Control').bind("click", function(){window.location.href = "9.1.0__ControlAssignment.html" + 
					"?LastURL=" + location.href + 
					"&ControlPath=" + getControlAssignmentPathBeepVario("ControlID", g_controlIDBeep, "VolumeBeep") + 
					"&ControlId=" + g_controlIDBeep +
					"&ControlNode=ControlID" +
					"&PageId=1" +
					"&FromName=Volume General"
			});
			
			$('#Vario_Offset_Control').bind("click", function(){window.location.href = "9.1.0__ControlAssignment.html" + 
					"?LastURL=" + location.href + 
					"&ControlPath=" + getControlAssignmentPathBeepVario("ControlID", g_controlIDVario, "VolumeVario") + 
					"&ControlId=" + g_controlIDVario +
					"&ControlNode=ControlID" +
					"&PageId=1" +
					"&FromName=Volume Vario"
			});
			
			$('#Voice_Offset_Control').bind("click", function(){window.location.href = "9.1.0__ControlAssignment.html" + 
					"?LastURL=" + location.href + 
					"&ControlPath=" + getControlAssignmentPathVoice("ControlID", g_controlIDVario, "VolumeVoice") + 
					"&ControlId=" + g_controlIDVoice +
					"&ControlNode=ControlID" +
					"&PageId=1" +
					"&FromName=Volume Voice"
			});
			
			$('#Display_Brightness_Control').bind("click", function(){window.location.href = "9.1.0__ControlAssignment.html" + 
					"?LastURL=" + location.href + 
					"&ControlPath=" + getControlAssignmentPathLight("ControlID", g_controlIDLight, "Brightness") + 
					"&ControlId=" + g_controlIDLight +
					"&ControlNode=ControlID" +
					"&PageId=1" +
					"&FromName=Brightness"
			});
			
			$('#General_Volume_High_Value').bind("click", function(){showNumpad("General_Volume_High_Value", "Control_Positiv");});
			$('#General_Volume_Center_Value').bind("click", function(){showNumpad("General_Volume_Center_Value", "Control_Positiv");});
			$('#General_Volume_Low_Value').bind("click", function(){showNumpad("General_Volume_Low_Value", "Control_Positiv");});
			
			$('#Vario_Offset_High_Value').bind("click", function(){showNumpad("Vario_Offset_High_Value", "Control");});
			$('#Vario_Offset_Center_Value').bind("click", function(){showNumpad("Vario_Offset_Center_Value", "Control");});
			$('#Vario_Offset_Low_Value').bind("click", function(){showNumpad("Vario_Offset_Low_Value", "Control");});
			
			$('#Voice_Offset_High_Value').bind("click", function(){showNumpad("Voice_Offset_High_Value", "Control");});
			$('#Voice_Offset_Center_Value').bind("click", function(){showNumpad("Voice_Offset_Center_Value", "Control");});
			$('#Voice_Offset_Low_Value').bind("click", function(){showNumpad("Voice_Offset_Low_Value", "Control");});
			
			$('#Display_Brightness_High_Value').bind("click", function(){showNumpad("Display_Brightness_High_Value", "Brightness");});
			$('#Display_Brightness_Center_Value').bind("click", function(){showNumpad("Display_Brightness_Center_Value", "Brightness");});
			$('#Display_Brightness_Low_Value').bind("click", function(){showNumpad("Display_Brightness_Low_Value", "Brightness");});
			
			controlBeep = new Object();
			controlBeep.ID = g_controlIDBeep;
			controlBeep.Value = 0;
		
			controlVario = new Object();
			controlVario.ID = g_controlIDVario;
			controlVario.Value = 0;
			
			controlVoice = new Object();
			controlVoice.ID = g_controlIDVoice;
			controlVoice.Value = 0;
			
			controlLight = new Object();
			controlLight.ID = g_controlIDLight;
			controlLight.Value = 0;
			
			controlIds.push(controlBeep, controlVario, controlVoice, controlLight);
		}
		else{
			g_numpadLimitObj = e.EventData.NumPadLimits;
		}	
		
	}catch(err){
		onError(err, "Error Init: ", false);
	}
}

//EVENT-Handler CONTROL/TELEMETRY Intervaldata
function handleEventControl(cmd, e, key, value, valueStr){
	//Control-Data
	if(cmd == "control"){
		if((key == g_controlIDBeep) || (key == g_controlIDVario) || (key == g_controlIDVoice) || (key == g_controlIDLight)){
			var val = Value12Bit2Percent(value);

			if(key == g_controlIDBeep){
				tagID = 'General_Volume_';
				
				if(typeof BeepState == 'undefined'){
					BeepState = "Invalid";
				}
				
				BeepState = setControlAssignments(tagID, val, BeepState);
			}
			
			if(key == g_controlIDVario){
				tagID = 'Vario_Offset_';
				
				if(typeof VarioState == 'undefined'){
					VarioState = "Invalid";
				}
				
				VarioState = setControlAssignments(tagID, val, VarioState);
			}
			
			if(key == g_controlIDVoice){
				tagID = 'Voice_Offset_';
				
				if(typeof VoiceState == 'undefined'){
					VoiceState = "Invalid";
				}
				
				VoiceState = setControlAssignments(tagID, val, VoiceState);
			}

			if(key == g_controlIDLight){
				tagID = 'Display_Brightness_';
				
				if(typeof LightState == 'undefined'){
					LightState = "Invalid";
				}
				
				LightState = setControlAssignments(tagID, val, LightState);
			}
		}
	}

	if(cmd == "AdditionalControlObject"){
		//Function-Data
		if(typeof htmlObj_BeepEmptyValue == 'undefined'){
			htmlObj_BeepEmptyValue = document.getElementById('General_Volume_Empty_Value');
		}

		htmlObj_BeepEmptyValue.innerHTML = e["EventData"]["general-settings"]["GeneralSettingsHK"]["VolumeBeep"]["Current"];
		
		if(typeof htmlObj_VarioEmptyValue == 'undefined'){
			htmlObj_VarioEmptyValue = document.getElementById('Vario_Offset_Empty_Value');
		}

		htmlObj_VarioEmptyValue.innerHTML = e["EventData"]["general-settings"]["GeneralSettingsHK"]["VolumeVario"]["Current"];
		
		if(typeof htmlObj_VoiceEmptyValue == 'undefined'){
			htmlObj_VoiceEmptyValue = document.getElementById('Voice_Offset_Empty_Value');
		}

		htmlObj_VoiceEmptyValue.innerHTML = e["EventData"]["general-settings"]["GeneralSoundConfig"]["VolumeVoice"]["Current"];
		
		if(typeof htmlObj_LightEmptyValue == 'undefined'){
			htmlObj_LightEmptyValue = document.getElementById('Display_Brightness_Empty_Value');
		}
		
		htmlObj_LightEmptyValue.innerHTML = e["EventData"]["general-settings"]["Brightness"]["Current"];
	}
}

//EVENT-Handler Setdata
function onEVENT_SET(e){
	try{
		if(e.cmd == "get"){
			handleGET(e);
		}
	}catch(err){
		onError(err, "Error Setdata: ", false);
	}	
}


function handleGET(TdJson){
	
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~Set Function~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
function getControlAssignmentPathBeepVario(controlNode, value, ListType){
	cmd = "set";
	TreeName = "general-settings";
	str = encodeURI('{"' + cmd + '":{"' + TreeName + '":{"GeneralSettingsHK":{"' + ListType + '":{"' + controlNode + '":"' + value + '"}}}}}');

	return str;
}

function getControlAssignmentPathVoice(controlNode, value, ListType){
	cmd = "set";
	TreeName = "general-settings";
	str = encodeURI('{"' + cmd + '":{"' + TreeName + '":{"GeneralSoundConfig":{"' + ListType + '":{"' + controlNode + '":"' + value + '"}}}}}');

	return str;
}

function getControlAssignmentPathLight(controlNode, value, ListType){
	cmd = "set";
	TreeName = "general-settings";
	str = encodeURI('{"' + cmd + '":{"' + TreeName + '":{"' + ListType + '":{"' + controlNode + '":"' + value + '"}}}}');

	return str;
}

function getAttrObj(tagId, value){
	Attribute = new Object();
	
	if(tagId[2] == "High"){
		Attribute["Hi"] = value;

		return 	Attribute;
	}

	if(tagId[2] == "Center"){
		Attribute["Center"] = value;

		return Attribute;
	}

	if(tagId[2] == "Low"){
		Attribute["Lo"] = value;

		return Attribute;
	}
	
	return Attribute;
}


function submitSET(tagId, value){
	var xmlObj = new Object();
	tagId = tagId.split("_");
	
	ModelName = "general-settings";
	cmd = "set";
	
	Attr = new Object();
	Attr = getAttrObj(tagId, value);
			
	xmlObj = {};
	xmlObj[cmd] = {};
	xmlObj[cmd][ModelName] = {};
	
	if((tagId[0] == "General") || (tagId[0] == "Vario")){
		xmlObj[cmd][ModelName]["GeneralSettingsHK"] = {};
		if(tagId[0] == "General"){
			type = "VolumeBeep";
		}
		if(tagId[0] == "Vario"){
			type = "VolumeVario"
		}
		xmlObj[cmd][ModelName]["GeneralSettingsHK"][type] = Attr;
	}
	else if(tagId[0] == "Voice"){
		xmlObj[cmd][ModelName]["GeneralSoundConfig"] = {};
		xmlObj[cmd][ModelName]["GeneralSoundConfig"]["VolumeVoice"] = Attr;
	}
	else{
		xmlObj[cmd][ModelName]["Brightness"] = Attr;
	}

	GetTd(xmlObj, g_SetEvent, cmd);
}
