/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~Seitenspezifisch~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
var g_isCalibrationActive = false;
		
initPage();

function initPage(){
//Telemetry
	telemetryTxHKStatusWord = new Object();
	telemetryTxHKStatusWord.ID = CONST_TELEMETRY_Tx_HKStatusWord;
	telemetryTxHKStatusWord.Value = 0;
	
	telemetryIds.push(telemetryTxHKStatusWord);
//Telemetry Ende

//Controls
	controlStickVertLeft = new Object();
	controlStickVertLeft.ID = CONST_CTRL_StickLeftVert;
	controlStickVertLeft.Value = 0;
	
	controlStickVertRight = new Object();
	controlStickVertRight.ID = CONST_CTRL_StickRightVert;
	controlStickVertRight.Value = 0;
	
	controlStickHoriLeft = new Object();
	controlStickHoriLeft.ID = CONST_CTRL_StickLeftHori;
	controlStickHoriLeft.Value = 0;
	
	controlStickHoriRight = new Object();
	controlStickHoriRight.ID = CONST_CTRL_StickRightHori;
	controlStickHoriRight.Value = 0;
	
	controlPotiTopLeft = new Object();
	controlPotiTopLeft.ID = CONST_CTRL_PotiLeftTop;
	controlPotiTopLeft.Value = 0;
	
	controlPotiTopRight = new Object();
	controlPotiTopRight.ID = CONST_CTRL_PotiRightTop;
	controlPotiTopRight.Value = 0;
	
	controlPotiSideLeft = new Object();
	controlPotiSideLeft.ID = CONST_CTRL_PotiLeftSide;
	controlPotiSideLeft.Value = 0;
	
	controlPotiSideRight = new Object();
	controlPotiSideRight.ID = CONST_CTRL_PotiRightSide;
	controlPotiSideRight.Value = 0;

	controlIds.push(
		controlStickVertLeft,
		controlStickVertRight,
		controlStickHoriLeft,
		controlStickHoriRight,
		controlPotiTopLeft,
		controlPotiTopRight,
		controlPotiSideLeft,
		controlPotiSideRight
	);
//Controls end	

	$('#Start_Calibration_Label').bind("click", function(){calibrate(0);});
	$('#Confirm_Calibration_Label').bind("click", function(){calibrate(1);});
	$('#SetCenter_Calibration_Label').bind("click", function(){calibrate(2);});
	
	$('#Navi_Button').removeAttr("href");
	$('#Navi_Button').bind("click", function(){
		if(g_isCalibrationActive){
			calibrate(2);
		}

		window.location.href = "2.0__GeneralSettings.html";
	});

	setInterval(JsonFunction, 250);
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~EVENT-Handler~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
var start = new Array();
var controlValue = new Array();
var onStartup = true;
var controlValueThreshold = 682; //entspricht 30% gesamt oder +60% bzw. -60%

//EVENT-Handler CONTROL/TELEMETRY Intervaldata
function handleEventControl(cmd, e, key, value, valueStr){
	//Telemetry
	if(cmd == "telemetry"){
		if(key == CONST_TELEMETRY_Tx_HKStatusWord){
			isCalibrationActive = 2&value;

			if(typeof preCalibration == "undefined"){
				preCalibration = -1;
			}

			if(isCalibrationActive != preCalibration){
				if(isCalibrationActive){
					g_isCalibrationActive = true;
					setHTML('Calibration_Text_Label', 'Move all controls which you want to be calibrated and press "Confirm" button');
					hideHTML('Start_Button');
					showHTML('Confirm_Button');
				}
				else{
					g_isCalibrationActive = false;
					setHTML('Calibration_Text_Label', 'Press "Start Calibration" button to begin calibration');
					hideHTML('SetCenter_Button');
					showHTML('Start_Button');
					ShowControlOverlayIcon(g_isCalibrationActive);
				}

				preCalibration = isCalibrationActive;
			}
		}
	}

	if(cmd == "control"){
		if(onStartup){
			for(var j = 0; j < controlIds.length; j++){
				start[j] = true;
				onStartup = false;
			}
		}

		for(var i = 0; i < controlIds.length; i++){
			if(key == controlIds[i].ID){
				checkForNew_CONTROL_ASSIGNMENT(i, key, value);

				break;
			}
		}
	}
}


function checkForNew_CONTROL_ASSIGNMENT(controlID, key, val){
	if(start[controlID]){
		controlValue[controlID] = val;
		start[controlID] = false;
	}
	else{
		if(Math.abs(val - controlValue[controlID]) > controlValueThreshold){
			log(3, "Wert von " + key + " mehr als 30% geaendert");
			ShowControlOverlayIcon(g_isCalibrationActive, key);
			controlValue[controlID] = val;
		}
	}
}


function calibrate(isCalibrationStart){
	var cmdr = new C_Commander();
	var par = {};

	switch(isCalibrationStart){
		case 0:	par[PN_WEA_CMD] = WEA_CMD_CALIBRATION_START;
				//par[PN_CALLB] = function(data) { log(data); };
				cmdr.SendCmd(par);
				break;
		case 1: setHTML('Calibration_Text_Label', 'Move controls in center position and press "Set Center Position" button');
				hideHTML('Confirm_Button');
				showHTML('SetCenter_Button');
				break;
		case 2:	par[PN_WEA_CMD] = WEA_CMD_CALIBRATION_STOP;
				//par[PN_CALLB] = function(data) { log(data); };
				cmdr.SendCmd(par);
				break;
	}	
}

/*BAT 60 specific*/
function ShowControlOverlayIcon(isCalibrationActive, ControlID){
	if(isCalibrationActive){
		switch(ControlID){
			case CONST_CTRL_PotiLeftSide:		showHTML('CTRL_PotiLeftSide');		break;
			case CONST_CTRL_PotiRightSide:		showHTML('CTRL_PotiRightSide');		break;
			case CONST_CTRL_PotiLeftTop:		showHTML('CTRL_PotiLeftTop');		break;
			case CONST_CTRL_PotiRightTop:		showHTML('CTRL_PotiRightTop');		break;
			case CONST_CTRL_StickLeftHori:		showHTML('CTRL_StickLeftHori');		break;
			case CONST_CTRL_StickLeftVert:		showHTML('CTRL_StickLeftVert');		break;
			case CONST_CTRL_StickRightHori:		showHTML('CTRL_StickRightHori');	break;
			case CONST_CTRL_StickRightVert:		showHTML('CTRL_StickRightVert');	break;
		}
	}
	else{
		hideHTML('CTRL_PotiLeftSide');
		hideHTML('CTRL_PotiRightSide');
		hideHTML('CTRL_PotiLeftTop');
		hideHTML('CTRL_PotiRightTop');
		hideHTML('CTRL_StickLeftHori');
		hideHTML('CTRL_StickLeftVert');
		hideHTML('CTRL_StickRightHori');
		hideHTML('CTRL_StickRightVert');
	}
}
/*BAT 60 specific End*/

var COMMANDER_URL_SERVERSIDE = "cgi/command"; 

var WEA_CMD_BINDING_START = 0x220;
var WEA_CMD_CALIBRATION_START = 0x312;
var WEA_CMD_CALIBRATION_STOP = 0x313;
var PN_WEA_CMD = 'cmd';
var PN_CMD_PARAM = 'param'; 
var PN_CALLB = 'Callback_param';
var AJAX_RQ_TYPE = 'POST';

/**************************************************************************//**
* @brief	Einen Befehl verschicken
* 
* Erforderliche Parameter:
* @param	args['wea-cmd'] 	- 	Menschfreundliche Befehldarstellung 
* 									(siehe oben Befehldefinitionen)
* 
* Nicht erforderliche Parameter:
* 
* @param	args[PN_CALLB] 		- 	Callback aufzurufen nach einer erfolgreichen 
* 									Antwort vom Server 
* @param	args[PN_ARGS] 		- 	Parameter für die Callback
*/
C_Commander.prototype.SendCmd = function(args)
{
	if(typeof args[PN_WEA_CMD] == 'undefined')
		throw {message: 'No command given', code: 0x702};
	
//	alert( args );
	this.SendRq(args);
};

/**************************************************************************//**
* @brief	C_Commander-Constructor
*/
function C_Commander(args)
{
	this.RqUrl = COMMANDER_URL_SERVERSIDE;
	this.LastResult = '';
}

/**************************************************************************//**
* @brief	Eine Anfrage verschicken
* 
* Erforderliche Parameter:
* @param	args['data'] 		- 	Daten zu verschicken
* 
* Nicht erforderliche Parameter:
* 
* @param	args[PN_CALLB] 		- 	Callback aufzurufen nach einer erfolgreichen 
* 									Antwort vom Server 
* @param	args[PN_ARGS] 		- 	Parameter für die Callback
*/
C_Commander.prototype.SendRq = function(args)
{
	var tmp = 
	{
		"cmd" : 0,
		"param" : {}
	};
	try
	{
		var self = this;
		log(2, args);
		
		var AjaxParam = {
			'type': AJAX_RQ_TYPE,
			'data': JSON.stringify(args),
			'async': true,
			'datatype': 'json',
			'url': this.RqUrl,
			'success': function(data) 
			{
				log(2, data);

				//self.LastResult = $.parseJSON(data);
				
//				if(typeof args[PN_CALLB] == 'function')
//				{
//					var tmp = {};
//					tmp[PN_CMD_PARAM] = args[PN_CMD_PARAM];
//					tmp['data'] = data;
//					
////					args[PN_CALLB](tmp);
//					alert(self.LastResult['result']);
//				}
			},
			'error': function(jqXHR , str, exc) 
			{ 
				try
				{
//					console.log(jqXHR);
//					console.log(str); 
//					console.log(exc); 
				}
				catch(exc)
				{
					onError(exc, "in C_Commander.SendRq: ", false);
				}
			}
		};
		
		$.ajax(AjaxParam);
	}
	catch(exc)
	{
		onError(exc, "in C_Commander.SendRq: ", false);
	}
};

/**************************************************************************//**
* @brief	Letztes Ergebnis
*/
C_Commander.prototype.GetResult = function()
{
	return this.LastResult;
};
