/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~Seitenspezifisch~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
//Stick-Controls
var StickControls = new Array();
StickControls["CTRL_StickPotiLeft"]		= CONST_CTRL_PotiLeftSide;
StickControls["CTRL_StickPotiRight"]	= CONST_CTRL_PotiStickRight;
StickControls["CTRL_StickRotaryLeft"]	= CONST_CTRL_RotaryStickLeft;
StickControls["CTRL_StickRotaryRight"]	= CONST_CTRL_RotaryStickRight;
StickControls["CTRL_StickSwitchLeft"]	= CONST_CTRL_SWStickLeft;
StickControls["CTRL_StickSwitchRight"]	= CONST_CTRL_SWStickRight;

StickControls["CTRL_StickButtonLeft"]	= CONST_CTRL_StickLeftButton;
StickControls["CTRL_StickButtonRight"]	= CONST_CTRL_StickRightButton;

//NEU Start
//StickControls["CTRL_StickRotaryButtonLeft"] 	   = CONST_CTRL_RotaryButtonStickLeft;
//StickControls["CTRL_StickRotaryButtonRight"] 	   = CONST_CTRL_RotaryButtonStickRight;
//StickControls["CTRL_StickRotaryToggleButtonLeft"]  = CONST_CTRL_RotaryToggleButtonStickLeft;
//StickControls["CTRL_StickRotaryToggleButtonRight"] = CONST_CTRL_RotaryToggleButtonStickRight;
//StickControls["CTRL_StickToggleButtonLeft"] 	   = CONST_CTRL_StickLeftToggleButton;
//StickControls["CTRL_StickToggleButtonRight"] 	   = CONST_CTRL_StickRightToggleButton;
StickControls["CTRL_StickButtonSwitchLeft"] 	   = CONST_CTRL_StickLeftButton + CONST_CTRL_SWStickLeft;
StickControls["CTRL_StickButtonSwitchRight"] 	   = CONST_CTRL_StickRightButton +  CONST_CTRL_SWStickRight;
//StickControls["CTRL_StickToggleButtonSwitchLeft"]  = CONST_CTRL_StickLeftToggleButtonSwitch;
//StickControls["CTRL_StickToggleButtonSwitchRight"] = CONST_CTRL_StickRightToggleButtonSwitch;
//NEU Ende

initPage();

function initPage(){
	$('#Navi_Button').removeAttr("href");
	$('#Navi_Button').bind("click", function(){
		showDialogbox('StrickControlInfo', 'The changes become only effective after restart your Transmitter.');
	});
	
//Alte XML Daten beschaffen
	GetTd({"cmd":0x0425, "param": {"Left": 0, "Right": 0}}, g_InitEvent, "command");
//XML Daten Ende	

	$('#Drop_Down_Content_Left').bind('click', function(){toggleDropDown('Left');});
	$('#Drop_Down_Arrow_Left').bind('click', function(){toggleDropDown('Left');});
	$('#Drop_Down_Content_Right').bind('click', function(){toggleDropDown('Right');});
	$('#Drop_Down_Arrow_Right').bind('click', function(){toggleDropDown('Right');});
	
	$('#Option_0_Left').bind('click', function(){setOption(0, "Left", false);});
	$('#Option_1_Left').bind('click', function(){setOption(1, "Left", false);});
	$('#Option_2_Left').bind('click', function(){setOption(2, "Left", false);});
	$('#Option_3_Left').bind('click', function(){setOption(3, "Left", false);});
	$('#Option_4_Left').bind('click', function(){setOption(4, "Left", false);});
	
	$('#Option_0_Right').bind('click', function(){setOption(0, "Right", false);});
	$('#Option_1_Right').bind('click', function(){setOption(1, "Right", false);});
	$('#Option_2_Right').bind('click', function(){setOption(2, "Right", false);});
	$('#Option_3_Right').bind('click', function(){setOption(3, "Right", false);});
	$('#Option_4_Right').bind('click', function(){setOption(4, "Right", false);});

	setInterval(JsonFunction, 250);
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~JSON-Object constructor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
//create and returns Servo object
function getStickControlObject(InitDataPostArgs){
	if(typeof InitDataPostArgs == "undefined")
		InitDataPostArgs = new Object();

	return InitDataPostArgs;	
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~EVENT-Handler~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
//EVENT-Handler INIT
function onEVENT_INIT(e){
	try{
		setOption(e.EventData.result.Left,  "Left",  true);
		setOption(e.EventData.result.Right, "Right", true);
	}catch(err){
		onError(err, "Error Init: ", false);
	}
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~Specific Function~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
function toggleDropDown(side){
	$('#Drop_Down_Options_' + side).toggle();
}


function setOption(index, side, isInit){
	showHTML('Option_0_' + side);
	showHTML('Option_1_' + side);
	showHTML('Option_2_' + side);
	showHTML('Option_3_' + side);
	showHTML('Option_4_' + side);
	hideHTML('Option_' + index + '_' + side);

	switch(index){
		case 0: setHTML('Drop_Down_Content_' + side, 'none');				ShowControlOverlayIcon("0", side); break;
		case 1: setHTML('Drop_Down_Content_' + side, 'Rotary');			ShowControlOverlayIcon(StickControls["CTRL_StickRotary" + side], side); break;
		case 2: setHTML('Drop_Down_Content_' + side, 'Button');			ShowControlOverlayIcon(StickControls["CTRL_StickButton" + side], side); break;
		case 3: setHTML('Drop_Down_Content_' + side, 'Switch');			ShowControlOverlayIcon(StickControls["CTRL_StickSwitch" + side], side); break;
		case 4: setHTML('Drop_Down_Content_' + side, 'Switch + Button');	ShowControlOverlayIcon(StickControls["CTRL_StickButtonSwitch" + side], side); break;
	}

	if(!isInit){
		toggleDropDown(side);
		if(side == "Left"){
			GetTd({"cmd":0x0424, "param": {"Left": index}}, "noEvent", "command");
		}
		else{
			GetTd({"cmd":0x0424, "param": {"Right": index}}, "noEvent", "command");
		}
	}	
}

/*BAT 60 specific*/	
function ShowControlOverlayIcon(ControlID, side){
	if((ControlID != "INVALID") && (ControlID != "0")){
		switch(ControlID){
			//case StickControls["CTRL_StickPotiLeft"]:					width = "75"; height = "47"; left_img = "243"; top_img = "100"; control_overlay_img = "data:image/png;base64,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"; break;
			//case StickControls["CTRL_StickPotiRight"]:					width = "75"; height = "47"; left_img = "442"; top_img = "100"; control_overlay_img = "data:image/png;base64,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"; break;
			case StickControls["CTRL_StickRotaryLeft"]:					width = "75"; height = "47"; left_img = "243"; top_img = "100"; control_overlay_img = "data:image/png;base64,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"; break;
			case StickControls["CTRL_StickRotaryRight"]:				width = "75"; height = "47"; left_img = "442"; top_img = "100"; control_overlay_img = "data:image/png;base64,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"; break;
			//case StickControls["CTRL_StickRotaryButtonLeft"]:			width = "75"; height = "47"; left_img = "243"; top_img = "99";  control_overlay_img = "/images/Control_RotaryButton.png"; break;
			//case StickControls["CTRL_StickRotaryButtonRight"]:			width = "75"; height = "47"; left_img = "442"; top_img = "99";  control_overlay_img = "/images/Control_RotaryButton.png"; break;
			//case StickControls["CTRL_StickRotaryToggleButtonLeft"]:		width = "75"; height = "47"; left_img = "243"; top_img = "99";  control_overlay_img = "/images/Control_RotaryToggleButton.png"; break;
			//case StickControls["CTRL_StickRotaryToggleButtonRight"]:	width = "75"; height = "47"; left_img = "442"; top_img = "99";  control_overlay_img = "/images/Control_RotaryToggleButton.png"; break;
			case StickControls["CTRL_StickSwitchLeft"]:					width = "29"; height = "46"; left_img = "266"; top_img = "113"; control_overlay_img = "data:image/png;base64,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"; break;
			case StickControls["CTRL_StickSwitchRight"]:				width = "29"; height = "46"; left_img = "465"; top_img = "113"; control_overlay_img = "data:image/png;base64,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"; break;
			case StickControls["CTRL_StickButtonSwitchLeft"]:			width = "75"; height = "47"; left_img = "243"; top_img = "113"; control_overlay_img = "data:image/png;base64,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"; break;
			case StickControls["CTRL_StickButtonSwitchRight"]:			width = "75"; height = "47"; left_img = "442"; top_img = "113"; control_overlay_img = "data:image/png;base64,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"; break;
			//case StickControls["CTRL_StickToggleButtonSwitchLeft"]:		width = "75"; height = "47"; left_img = "243"; top_img = "113"; control_overlay_img = "/images/Control_ToggleButtonSwitch.png"; break;
			//case StickControls["CTRL_StickToggleButtonSwitchRight"]:	width = "75"; height = "47"; left_img = "442"; top_img = "113"; control_overlay_img = "/images/Control_ToggleButtonSwitch.png"; break;
			case StickControls["CTRL_StickButtonLeft"]:					width = "75"; height = "47"; left_img = "243"; top_img = "99";  control_overlay_img = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEsAAAAvCAMAAACc9ceUAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAEFUExURQAAAP///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAAAYBAQkBAQ8CAhICAhUCAhgDAxsDAx4DAyEEBCQEBC0FBTMGBjkGBkIICEsJCU4JCVcKCloKCmYMDGkMDGwMDG8NDXgODoQPD4cPD5YREaUTE6gTE7oVFb0VFcYXF8kXF9IYGNsZGeEaGuQaGucaGuobG/AbG/YcHPkcHPwdHf8dHd0IkuIAAAAqdFJOUwAACA4QERMUFhcZHR4hIyYtMDM8SEtaaWyZnJ+lqKuusbS3usPP2OHk8Ltat84AAAFTSURBVEjH7dbbVoJAFAbg3cEsyaTzychyKv0rooNUmlnZOcsy5f0fpQsYEEJbM9Ad/+WG9a0Fs/deQyNDQxvwskV/vDz88QSOrnlOMS1jEY8K0+KpYtGtJ1bAyszZ8Vt2LStmbbqN0G/xbItYGRyfO7lyrVteOkNWwJqE8WENSseEKvKNGszOAKp7CSb0v8YYqr1wq45dRewclT3chFJ3KOdE+2sWeAihHoF58V5dwv7zL+rlAMsyfb8KvRWgWjrW5GYoj8qXj2qfIC87j0VcdPuobxMF6dme2kHdo3o1sJT8nsiV0XStBkozUXbOAvDkUPeAGml/0QoO33hjeetLzqJ1GG3Lsl6dxopk2WP+bjiNFc1KMdQ+K9AoBouUEnQUR2OxKK1BS1M8FtF4sCB6ByBSGfxhKpHUfYIoSAFM2gICOwdIrMRKrMT6NyvO/SW4V38AZ17t/XBA7wMAAAAASUVORK5CYII="; break;
			case StickControls["CTRL_StickButtonRight"]:				width = "75"; height = "47"; left_img = "443"; top_img = "99";  control_overlay_img = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEsAAAAvCAMAAACc9ceUAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAEFUExURQAAAP///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAAAYBAQkBAQ8CAhICAhUCAhgDAxsDAx4DAyEEBCQEBC0FBTMGBjkGBkIICEsJCU4JCVcKCloKCmYMDGkMDGwMDG8NDXgODoQPD4cPD5YREaUTE6gTE7oVFb0VFcYXF8kXF9IYGNsZGeEaGuQaGucaGuobG/AbG/YcHPkcHPwdHf8dHd0IkuIAAAAqdFJOUwAACA4QERMUFhcZHR4hIyYtMDM8SEtaaWyZnJ+lqKuusbS3usPP2OHk8Ltat84AAAFTSURBVEjH7dbbVoJAFAbg3cEsyaTzychyKv0rooNUmlnZOcsy5f0fpQsYEEJbM9Ad/+WG9a0Fs/deQyNDQxvwskV/vDz88QSOrnlOMS1jEY8K0+KpYtGtJ1bAyszZ8Vt2LStmbbqN0G/xbItYGRyfO7lyrVteOkNWwJqE8WENSseEKvKNGszOAKp7CSb0v8YYqr1wq45dRewclT3chFJ3KOdE+2sWeAihHoF58V5dwv7zL+rlAMsyfb8KvRWgWjrW5GYoj8qXj2qfIC87j0VcdPuobxMF6dme2kHdo3o1sJT8nsiV0XStBkozUXbOAvDkUPeAGml/0QoO33hjeetLzqJ1GG3Lsl6dxopk2WP+bjiNFc1KMdQ+K9AoBouUEnQUR2OxKK1BS1M8FtF4sCB6ByBSGfxhKpHUfYIoSAFM2gICOwdIrMRKrMT6NyvO/SW4V38AZ17t/XBA7wMAAAAASUVORK5CYII="; break;
			//case StickControls["CTRL_StickToggleButtonLeft"]:			width = "75"; height = "47"; left_img = "243"; top_img = "99";  control_overlay_img = "/images/Control_ToggleButton.png"; break;
			//case StickControls["CTRL_StickToggleButtonRight"]:			width = "75"; height = "47"; left_img = "443"; top_img = "99";  control_overlay_img = "/images/Control_ToggleButton.png"; break;
			default:													width = "";	  height = "";	 left_img = "";    top_img = "";	control_overlay_img = "";
		}

		setHTML('Control_Overlay_' + side, '<div style=\"width: ' + width + 'px; height: ' + height + 'px; left: ' + left_img + 'px; top: ' + top_img + 'px; position: absolute;\"><img src=\"' + control_overlay_img + '\" width=\"' + width + '\" height=\"' + height + '\" alt=\"\" draggable=\"false\" /></div>');
	}
	else{
		setHTML('Control_Overlay_' + side, '');
	}
}
/*BAT 60 specific*/	
