/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~Seitenspezifisch~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

var g_List_Count = 0;			//Number of Modes shown in list		
var g_List_Indices = [];		//List of Modes Indices
var toggleStateARD = "normal";	//Button state ("add", "reorder", "delete")

var g_List_PopupListObj = [];

var g_TriggerState = [];
initPage();

function initPage(){
		
//Alte XML Daten beschaffen
	InitDataPostArgs = getPopupObj(InitDataPostArgs, "SoundModeLVarioActivity");
	InitDataPostArgs = getPopupObj(InitDataPostArgs, "AudioFileChoice");
	GetTd(getCurrentModelName(InitDataPostArgs), g_InitEvent);
	
	InitDataPostArgsExtended = new Object();
	GetTd(getSoundConfigObject(InitDataPostArgsExtended), g_InitEvent, "get");
//XML Daten Ende	

	g_isAdditionalControlObjectUsed = true;
	TdPostArgs = getCurrentSoundModeObject(TdPostArgs);
	setInterval(JsonFunction, 250);
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~JSON-Object constructor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
//create and returns Voice And Sound-List init-object
function getSoundConfigObject(InitDataPostArgsExtended){
	if(typeof InitDataPostArgsExtended == "undefined"){
		InitDataPostArgsExtended = new Object();
	}

	cmd = "get";
	ModelName = "model-settings";
	ListType = "SoundMode";

	Item = new Object();
	Item.Index = -1;
	Item.Name = "";
		islinkVario = new Object();
		islinkVario.Index = -1;
		islinkVario.Name = "";
	Item.IsLinkVarioActive = islinkVario;
		audiFile= new Object();
		audiFile.Index = -1;
		audiFile.Name = "";
	Item.AudioFile = audiFile;
		control = new Object();
		control.Control = -1;
		control.Trigger = -1;
	Item.Switch = control;
	
	modeItem = new Array(Item);
	
	InitDataPostArgsExtended[cmd] = {};
	InitDataPostArgsExtended[cmd][ModelName] = {};
	InitDataPostArgsExtended[cmd][ModelName][ListType] = {};
	InitDataPostArgsExtended[cmd][ModelName][ListType]["Items"] = "ALL";
	InitDataPostArgsExtended[cmd][ModelName][ListType]["Item"] = modeItem;
  
	return InitDataPostArgsExtended;	
}

//create and returns SoundMode-current-object
function getCurrentSoundModeObject(TdPostArgs){
	if(typeof TdPostArgs == "undefined"){
		TdPostArgs = new Object();
	}

	soundMode = new Object();
		current = new Object();
		current.State = [];
	soundMode.Current = current;
	
	TdPostArgs.SoundMode = soundMode;
	
	return TdPostArgs;	
}	

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~EVENT-Handler~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
//EVENT-Handler INIT
function onEVENT_INIT(e){
	try{
		if(typeof e.EventData.get == "undefined"){
			checkHTMLHeader('Model_Name');
			setHTML('Model_Name', e.EventData.ModelName);
			
			//Listener
			//ARD and bottom Buttons
			$('#Add_Button').bind("click", function(){AddItem(1);});
			$('#Reorder_Button').bind("click", function(){toggleReorder();});
			$('#Delete_Button').bind("click", function(){toggleDelete();});
			$('#Navi_Button').removeAttr("href");
			$('#Navi_Button').bind("click", function(){toggleARD('1.0.0__ModelSettings.html');});

			g_List_PopupListObj["SoundModeLVarioActivity"] = e.EventData.PopUp.SoundModeLVarioActivity;
			g_List_PopupListObj["AudioFileChoice"] = e.EventData.PopUp.AudioFileChoice;
		}
		else{
			var i = 0;
			var htmlOuterContainer = "";

			g_List_Indices = new Array ();
			g_List_Count = e.EventData.get.SoundMode.Item.length;
			
			for(i = 0; i < g_List_Count; i++){
				g_List_Indices[i] = e.EventData.get.SoundMode.Item[i].Index;
				htmlOuterContainer += getRowRD(g_List_Indices[i], e.EventData.get.SoundMode.Item[i].Name, 'Modus');
			}	

			$("#scrollContainerInnerVertical").html(htmlOuterContainer);

			for(i = 0; i < g_List_Count; i++){
				Index       = e.EventData.get.SoundMode.Item[i].Index;
				Mode		= e.EventData.get.SoundMode.Item[i].Name;
				File        = e.EventData.get.SoundMode.Item[i].AudioFile.Name;
				ModeControl	= e.EventData.get.SoundMode.Item[i].Switch.Control;
				ModeTrigger = triggerPercent2Uint8(e.EventData.get.SoundMode.Item[i].Switch.Trigger);
				isVario     = e.EventData.get.SoundMode.Item[i].IsLinkVarioActive.Name;
							
				$("#Container_" + Index).html(getRowOfModesList(Index, Mode, File, isVario, ModeControl, ModeTrigger, getControlAssignmentPath(ModeControl, ModeTrigger, Index)));
				
				control2image("VoiceSounds_Control_" + Index, ModeControl);
				setTriggerState("VoiceSounds_Trigger_" + Index, ModeTrigger);
				trigger2image("VoiceSounds_Trigger_" + Index, 0);
				
				//Popup-List
				g_popupList_Indices["VoiceSounds__" + Index + "_IsLinkVarioActive"] = e.EventData.get.SoundMode.Item[i].IsLinkVarioActive.Index;
				$('#VoiceSounds__' + Index + '_IsLinkVarioActive').bind("click", function(){showPopupList(this, g_List_PopupListObj["SoundModeLVarioActivity"], false, true, g_popupList_Indices);});
				
				g_popupList_Indices["VoiceSounds__" + Index + "_AudioFile"] = e.EventData.get.SoundMode.Item[i].AudioFile.Index;
				$('#VoiceSounds__' + Index + '_AudioFile').bind("click", function(){showPopupList(this, g_List_PopupListObj["AudioFileChoice"], false, true, g_popupList_Indices);});
				//Listener end
			}
			initScrollbars('List_Container');
		}
	}catch(err){
		onError(err, "Error Init: ", false);
	}
}

//EVENT-Handler CONTROL/TELEMETRY Intervaldata
function handleEventControl(cmd, e, key, value, valueStr){
	if(cmd == "AdditionalControlObject"){
		for(var i = 0; i < g_List_Count; i++){
			if(e.EventData.SoundMode.Current.State[g_List_Indices[i]] == 1){
				$('#Container_' + g_List_Indices[i]).addClass("active_modi");
			}
			else{
					$('#Container_' + g_List_Indices[i]).removeClass("active_modi");
			}
			//trigger2image("VoiceSounds_Trigger_" + g_List_Indices[i], e.EventData.SoundMode.Current.State[g_List_Indices[i]]); not used
		}
	}
}

//EVENT-Handler Setdata
function onEVENT_SET(e){
	try{
		if(e.cmd == "add"){
			createAddItem(e.EventData);
		}
	}catch(err){
		onError(err, "Error Setdata: ", false);
	}	
}
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~Specific Function~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

function getSavePath(modeIndex){
	cmd = "set";
	ModelName = "model-settings";
	path = "www";
	str = encodeURI('{"' + cmd + '":{"' + ModelName + '":{"SoundMode":{"AudioFile":"' + path + '","Index":' + modeIndex + '}}}}'); 

	return str;
}

function getControlAssignmentPath(control, trigger, Index){
	cmd = "set";
	ModelName = "model-settings";
	str = encodeURI('{"' + cmd + '":{"' + ModelName + '":{"SoundMode":{"Switch":{"Control":' + control + ',"Trigger":' + trigger +'},"Index":' + Index + '}}}}'); 

	return str;
}

//Converts a state from a switch to an trigger-image.
function trigger2image(id, state){
//	$('#' + id).removeClass(g_TriggerState[id][state^1]);
//	$('#' + id).addClass(g_TriggerState[id][state]);
	$('#' + id).addClass(g_TriggerState[id][0]);
}

//Set Trigger States
function setTriggerState(tagId, trigger){
	var triggerArray = new Array();
	
	switch(trigger){
		case 	  512:  	triggerArray[0] = "icon_trigger_p25_white";
							triggerArray[1] = "icon_trigger_p25_blue";
							break;
		case 	 -512:  	triggerArray[0] = "icon_trigger_m25_white";
							triggerArray[1] = "icon_trigger_m25_blue";
							break;
		case 	  1536:		triggerArray[0] = "icon_trigger_p75_white";
							triggerArray[1] = "icon_trigger_p75_blue";
							break;
		case 	 -1536:		triggerArray[0] = "icon_trigger_m75_white";
							triggerArray[1] = "icon_trigger_m75_blue";
							break;
		default:			triggerArray[0] = "icon_trigger_empty";
							triggerArray[1] = "icon_trigger_empty";
	}

	g_TriggerState[tagId] = triggerArray;
}

function triggerPercent2Uint8(trigger){
	
	switch(trigger){
		case 	  "+25%":  	trigger = 512;
							break;
		case 	 "-25%":  	trigger = -512;
							break;
		case 	  "+75%":	trigger = 1536;
							break;
		case 	 "-75%":	trigger = -1536;
							break;
		default:			trigger = 0;
	}

	return trigger;
}
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~HTML-constructor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
//Create and return HTML-Code for one Row of Voice And Sound-List 
function getRowOfModesList(Index, Mode, File, isVario, ModeControl, ModeTrigger, ModeControlObj){
	var htmlInnerContainer = '' +
							'<div id="VoiceSounds__' + Index + '_Mode" class="list_voicesounds_mode" onClick=\'showKeypad("VoiceSounds__' + Index + '_Mode");\'>' + Mode + '</div>' +
							'<div id="VoiceSounds__' + Index + '_AudioFile" class="list_voicesounds_file">' + File + '</div>' +
							'<div id="VoiceSounds__' + Index + '_IsLinkVarioActive" class="list_voicesounds_vario">' + isVario +
								'<!-- <div id="VoiceSounds_General_Vario_Enable" class="background" style="width: 40px; height: 40px; border: 2px solid #fff; border-radius: 4px; padding:0px; margin: 12px 0px 0px 10px;">' +
									'<img id="VoiceSounds_General_Vario_Enable_Img" width="42" height="35" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACoAAAAjCAYAAADizJiTAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA2RpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMC1jMDYwIDYxLjEzNDc3NywgMjAxMC8wMi8xMi0xNzozMjowMCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDo4QUU1Nzg4RUM3NDRFMjExQTNCREVFNkMxQjk4MkM0NiIgeG1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDpCQUIxRDZCQTlCMEExMUUyQTcxMEEzNzJDMzE5ODFDMyIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDpCQUIxRDZCOTlCMEExMUUyQTcxMEEzNzJDMzE5ODFDMyIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ1M1IFdpbmRvd3MiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDpBQkE3RDFEQUYyOUFFMjExQkY4NkRDQzBDNkQwODQ3QiIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDo4QUU1Nzg4RUM3NDRFMjExQTNCREVFNkMxQjk4MkM0NiIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/Psw8DHIAAADdSURBVHja7NjrCoMwDAXg6fbcGWcv3lHYj9GbaTpPMvBAQaHgh61NcEsp3f4heyCLfEYzj0BIfN2/qhl56Z2HpDpSzouIbGKjIivsHmRP9nL33KOaN5kDz6U3IdlQM5IJXUKyoMtIBvQnyCOotCqEB3IElVE5YyN7UFXtZSJbUHXtZSJL6FTtZSJLKJQPEjaytfQW7OnI3sc0g6UgR8eTFktBHh34iILUlFBEQGprPbyRM00JPJGz3RO8kJY2Dx5Iaz8KNnKlcQYTmYf139Ozc31atuu34wUNnrcAAwCJ1ARaCuqr5QAAAABJRU5ErkJggg==" style="margin: 4px 0px 0px -1px; display: none;" draggable="false" />' +
								'</div>	-->' +
							'</div>' +
							
							'<div class="list_voicesounds_switch">' +
							'<div id="VoiceSounds_Trigger_' + Index + '" style="margin-top: 8px;"></div>' +
								'<a href="9.1.0__ControlAssignment.html?PageId=10&FromName=VoiceAndSounds&FromNameSub=' + Mode + '&ControlId=' + ModeControl + '&ControlTrigger=' + ModeTrigger + '&ControlNode=Control&ControlNodeTrigger=Trigger&ControlPath=' + ModeControlObj + '&LastURL=' + location.href +'" draggable="false">' +
									'<img width="85" height="61" id="VoiceSounds_Control_' + Index + '" src="" draggable="false" alt=""/>' +
								'</a>' +
							'</div>' +
							
							'<div id="VoiceSounds_General_Setup_Sound" class="list_voicesounds_setup">' +
								'<a href="1.7.1__VoiceAndSoundsSpeech.html?SetupModeIndex=' + Index + '" draggable="false">' +
									'<img width="55" height="50" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABsAAAAbCAYAAACN1PRVAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyBpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMC1jMDYwIDYxLjEzNDc3NywgMjAxMC8wMi8xMi0xNzozMjowMCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNSBXaW5kb3dzIiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOjVEQzNDOTAzOUEzRTExRTI5Q0RBQTdENTZGMUE1QURFIiB4bXBNTTpEb2N1bWVudElEPSJ4bXAuZGlkOjVEQzNDOTA0OUEzRTExRTI5Q0RBQTdENTZGMUE1QURFIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6NURDM0M5MDE5QTNFMTFFMjlDREFBN0Q1NkYxQTVBREUiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6NURDM0M5MDI5QTNFMTFFMjlDREFBN0Q1NkYxQTVBREUiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz5CqgjoAAABgElEQVR42ryVQUSEQRTHv61ELNEpIiIiIpYo0ZK6l4go0SGdikSnTZFu6dSt05IiUd/G2tOmFF33FJ0iIqJTdKn/4z9My7bzZufr8fOZNbO/b95730wqjuPIM9LgAoy7LmjxFHWCAshoFvnIekAJ9GoXNinnD4I7H5FWNgZumMIoSdkMU5d2nD8HTnxkK1zYqtiEpHkWbGpk2+AQNDtKzLwdcMX1XdWy7xrkFLuRVJdBG8drlOd8u/GvkDSPgg2On8ApmDcvEFJ2DIpg1UrnGUXDoWUSR6ADDHFc4XMgCZn58z4+X6zjLbjMrp/EVyPHVb3IWM0h0W3vMLRsEbyBe45/1S6kbAlMgH3wyd+mwAd4CC17BdeUSfTzQ88buZGlarCukMnxlGVTyHd2QMmua4PIWy5Ud5VD7DGlW9yx802dZ9HPrXOvXtyCdiulqtYvMkXvjvMvwXIjN7V01Ah4TvqmNvFIYeU/ZOY0yLIuicsi1m6StUlcFvEbmtYs+BFgAHsfRy23jY72AAAAAElFTkSuQmCC" alt="" draggable="false"/>' +
								'</a>' +
							'</div>' +
							'<div id="VoiceSounds_General_Setup_Alerts" class="list_voicesounds_setup">' +
								'<a href="1.7.2__VoiceAndSoundsAlerts.html?SetupModeIndex=' + Index +'" draggable="false">' +
									'<img width="55" height="50" src="data:image/png;base64,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" alt="" draggable="false"/>' +
								'</a>' +
							'</div>';
	
	return htmlInnerContainer;
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~Set Function~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/		
function getAttrObj(tagId, value, index){
	Attribute = new Object();

	if(tagId == "Mode"){
		Attribute["Name"] = value;

		return Attribute;
	}

	if(tagId == "Vario"){
		Attribute["Vario"] = value;

		return Attribute;
	}
	if(tagId == "AudioFile"){
		if(value == 1){
			temp = getSavePath(index);
			window.location.href = "9.4.0__FileManager.html?IsManager=0&ManagementType=soundManagement&SavePathObj=" + temp + "&SearchKeyNode=AudioFile&LastURL=" + location.href;
		}
		else{
			Attribute["AudioFile"] = "";
		}
	}

	return Attribute;
}


function getPathObj(cmd, ModelName){
	xmlObj = {};
	xmlObj[cmd] = {};
	xmlObj[cmd][ModelName] = {};

	return xmlObj;
}


function submitSET(tagId, value){
	tagIdArray = tagId.split("__");
	cmd = "set";
	ModelName = "model-settings";
	ListType = tagIdArray[0];
	tagIdArray = tagIdArray[1].split("_");
	Index = parseInt(tagIdArray[0]);
	tagId = tagIdArray[1];
	ListType = "SoundMode";
	
	Attr = new Object();
	Attr = getAttrObj(tagId, value, Index);

	xmlObj = getPathObj(cmd, ModelName);
	xmlObj[cmd][ModelName][ListType] = {};
	xmlObj[cmd][ModelName][ListType] = Attr;
	xmlObj[cmd][ModelName][ListType]["Index"] = Index;
	xmlObj[cmd][ModelName][ListType][tagId] = value;
	
	GetTd(xmlObj, g_SetEvent, cmd);
}


function submitARD(cmd, num){
	ModelName = "model-settings";
	ListType = "SoundMode";

	xmlObj = getPathObj(cmd, ModelName);
	xmlObj[cmd][ModelName][ListType] = num;

	GetTd(xmlObj, g_SetEvent, cmd);
}
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ARD and bottom button list functions~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
//Add-Botton -> adds a new list item
function AddItem(count){
	submitARD("add", count);
}


function toggleDelete(){
	hideHTML("ARD_Buttons");
	setCSS("List_Container", "width", "778px");
	setCSS("scrollContainerInnerVertical", "width", "778px");
	
	for(var i = 0; i < g_List_Count; i++){
		showHTML("Delete_Button_" + g_List_Indices[i]);
	}	

	toggleStateARD = "delete";
}


function deleteItem(index){
	$("#ContainerOuter_" + index).remove();
		
	submitARD("remove", index);
	
	newIndices = [];
	var j = 0;
	
	for(var i = 0; i < g_List_Count; i++){
		if(g_List_Indices[i] != index){
			newIndices[j] = g_List_Indices[i];
			j++;
		}
	}

	g_List_Count--;
	g_List_Indices = newIndices;

	if(g_List_Count == 0){
		toggleARD("normal");
	}

	ScrollDownRefresh();
}


function toggleReorder(){
	hideHTML("ARD_Buttons");
	setCSS("List_Container", "width", "778px");
	setCSS("scrollContainerInnerVertical", "width", "778px");

	for(var i = 1; i < g_List_Count; i++)
		showHTML("Reorder_Button_" + g_List_Indices[i]);

	toggleStateARD = "reorder";
}


function raiseElement(Index){
	location.reload();
}


function toggleARD(link){
	if(toggleStateARD == "normal"){
		window.location.href = link;
	}
	else if(toggleStateARD == "delete"){
		for(var i = 0; i < g_List_Count; i++)
			hideHTML("Delete_Button_" + g_List_Indices[i]);

		setCSS("List_Container", "width", "674px");
		setCSS("scrollContainerInnerVertical", "width", "674px");
		showHTML("ARD_Buttons");
		toggleStateARD = "normal";	
	}
	else if(toggleStateARD == "reorder"){
		for(var i = 1; i < g_List_Count; i++)
			$("#Reorder_Button_" + g_List_Indices[i]).hide();

		setCSS("List_Container", "width", "674px");
		setCSS("scrollContainerInnerVertical", "width", "674px");
		showHTML("ARD_Buttons");
		toggleStateARD = "normal";		
	}
}

//Specific ARD Functions
function createAddItem(TdJson){
	log(2, "success ADD: " + JSON.stringify(TdJson));
	
	Index          = TdJson.add.SoundMode.Index;
	Mode		   = TdJson.add.SoundMode.Name;
	File           = TdJson.add.SoundMode.AudioFile.Name;
	ModeControl	   = parseInt(TdJson.add.SoundMode.Switch.Control);
	ModeTrigger	   = triggerPercent2Uint8(TdJson.add.SoundMode.Switch.Trigger);
	isVario        = TdJson.add.SoundMode.IsLinkVarioActive.Name;
				
	g_List_Indices.push(Index);
	g_List_Count = g_List_Indices.length;
	
	var newChild = getRowRD(Index, Mode, 'Modus');
	$("#scrollContainerInnerVertical").append(newChild);

	$('#Container_' + Index).html(getRowOfModesList(Index, Mode, File, isVario, ModeControl, ModeTrigger, getControlAssignmentPath(ModeControl, ModeTrigger, Index)));
	
	control2image("VoiceSounds_Control_" + Index, ModeControl);
	setTriggerState("VoiceSounds_Trigger_" + Index, ModeTrigger);
	trigger2image("VoiceSounds_Trigger_" + Index, 0);
	
	//Popup-List
	g_popupList_Indices["VoiceSounds__" + Index + "_IsLinkVarioActive"] = TdJson.add.SoundMode.IsLinkVarioActive.Index;
	$('#VoiceSounds__' + Index + '_IsLinkVarioActive').bind("click", function(){showPopupList(this, g_List_PopupListObj["SoundModeLVarioActivity"], false, true, g_popupList_Indices);});

	ScrollDownRefresh();
}
