#!/bin/bash -e

# globale Funktionen inkludieren
. '/etc/bat60_scripts/scripts/includes/functions_global.sh'

#######################

tmp_dir="$TMP_DIR"
is_logopt=true

declare -a files_to_update

files_to_update[0]='rc.local=/etc/init.d'								
files_to_update[1]='wpa_supplicant.conf=/media/card-internal'			
files_to_update[2]='wpa_supplicant=/usr/local/bin'					
files_to_update[3]='wpa_cli=/usr/local/bin'							
files_to_update[4]='locale=/media/card-internal'	

mount - / -o remount,rw						

for index in "${!files_to_update[@]}" ; do
	
	file=$(echo ${files_to_update[$index]} | sed -e "s/\(.*\)=.*/\1/g")
	dest=$(echo ${files_to_update[$index]} | sed -e "s/.*=\(.*\)/\1/g")
	
	if [ -e "$SERVICE_FILES_DIR"/"$file" ] ; then
		bat_log "Copying $file to $dest" 
		cp -Rf "$SERVICE_FILES_DIR"/"$file" "$dest"	
	fi
done

mount - / -o remount,ro	
