#!/bin/bash

#Erstellt einen Archiv mit Dateien je nach option (nur www oder daemons -Ordner bzw. beide)
#Argumente:
#$1 - Operationen, bspw. -wd
#	d - Daemon miteinbinden
#	w - Webinterface miteinbinden
#	c - archiv erstellen
#	x - archiv entpacken
########################################3
#$2 - Versionsname zum komprimieren oder Archivname zum dekomprimieren

#Diverse lokale Variablen werden deklariert
argc=2
USAGE_STRING="Usage: $0 [OPTION]... [ARCHIV|VERSION]..."
TRYHELP_STRING="try \`$0 --help' for more information"

# globale Funktionen inkludieren
. '/etc/bat60_scripts/scripts/includes/functions_global.sh'

is_logopt=true

#	zzt. werden parameter fuer daemons und www-Verzeichnisse unterstuetzt
valid_options='dwcxLfs'

bat_log 'Checking command line arguments'

#wenn Argumentanzahl nicht uebereinstimmt
if [ $# -lt $argc ] ;
then
	bat_log "$USAGE_STRING"
	exit 1
fi

ops=$1
archiv_ver_name=$2

#ist kein fuehrender Bindestrich, abbrechen
if [ ${ops:0:1} != '-' ] ; then
	bat_log "$USAGE_STRING"
	exit 1
fi

options=''

bat_log 'Checking options'

#	Pruefen, ob Optionen unterstuetzt werden
for (( i=1; $i<${#ops}; i++ )); do
	
	if [[ $valid_options == *${ops:$i:1}* ]] ; then
		options="$options""${ops:$i:1}"
		if [[ ${ops:$i:1} == 'L' ]] ; then 
			is_logopt=false
		fi
	else
		bat_log "Invalid option ${ops:$i:1}"
		bat_log "$TRYHELP_STRING"
		exit 1
	fi
done





###############################################################################
##	Komprimierfunktion
function compress_software
{
	bat_log 'Starting software compressing'
	
	###########################################
	##
	if [ -z $1 ] ; then
		bat_log "No options to compress_software"
		exit 1
	fi
	
	###########################################
	##
	if [ -z $2 ] ; then
		bat_log "No version to compress_software"
		exit 1
	fi
	
	local options=$1
	local archiv_ver=$2
	
#	nach Optionen entsprechende Verzeichnissse komprimieren
	local tar_dirs=''															#	Temproaere Ordner
	local tmpdir_daemons='daemons'
	local tmpdir_www='public'
	
	bat_log 'Determining packages to compress'	

#	Gehe Optionen durch und kopiere entsprechende Verzeichnisse
	declare -a tar_dirs
	idx=0
	for (( i=0; $i<"${#options}"; i++ )); do
		case ${options:$i:1} in
		# Daemons
		'd')
			bat_log "Compressing daemons..."
			mkdir -p $tmpdir_daemons
			cp -Rf "${DAEMON_DIR_ARM}"/* "$tmpdir_daemons"
			chmod -R 0777 "$tmpdir_daemons"
			chown -R www-data "$tmpdir_daemons"
			chgrp -R www-data "$tmpdir_daemons"
			tar_dirs[idx]="$tmpdir_daemons"
			idx=$idx+1
			;;
		# Web
		'w')
			bat_log "Compressing webinterface..."
			mkdir -p $tmpdir_www
			cp -Rf ${WWW_DIR}/* "$tmpdir_www"
			cp -Rf ${WWW_DIR}/* "$tmpdir_www"
			#rm -Rf "$tmpdir_www/xml"
			chmod -R 0777 "$tmpdir_www"
			chown -R www-data "$tmpdir_www"
			chgrp -R www-data "$tmpdir_www"
			tar_dirs[idx]=$tmpdir_www
			idx=$idx+1
			;;
		# Skripte
		's')
			bat_log "Compressing scripts..."
			local tmpdir_scripts='bat60_scripts/scripts/'
			mkdir -p "$tmpdir_scripts/includes" "$tmpdir_scripts/startup" "$tmpdir_scripts/update_files"
			cp -Rf "${BAT_SCRIPTS}/includes"/* "$tmpdir_scripts/includes"
			cp -Rf "${BAT_SCRIPTS}/startup"/* "$tmpdir_scripts/startup"
			cp -Rf "${BAT_SCRIPTS}/update_files"/* "$tmpdir_scripts/update_files"
			rm -f "$tmpdir_scripts/startup/tbd_bat60_startup.sh"
			tmpdir_scripts='bat60_scripts'
			tar_dirs[idx]="$tmpdir_scripts"
			idx=$idx+1
			;;
		esac
	done
	
	
	if [ -z $tar_dirs ] ; then
		bat_log "No software parts chosen"
		bat_log "$TRYHELP_STRING"
		exit 1
	fi

	bat_log 'Creating archiv'	
	
#	Archiv erstellen
	linux_archiv="$LINUX_UPDT_FILENAME"'_'"$VERSION_PREFIX""$archiv_ver"'.tar.gz'
	tar -zcvf $linux_archiv "${tar_dirs[@]}"
	chmod a+rw $linux_archiv
#	mv $linux_archiv $updt_files_dir
	
	bat_log 'Removing temp files'	

#	temproraere Files und Ordner entfernen
	echo "rm -Rf ${tar_dirs[@]}"
	rm -Rf "${tar_dirs[@]}"
}

###############################################################################
##	Dekomprimierfunktion
function extract_software
{
	bat_log 'Starting software extracting and update'	

	local l_options=$1
	local software_archiv=$2
	
	local tmpdir_daemons='daemons'
	local tmpdir_www='public'
	local tmpdir_scripts='bat60_scripts/scripts/'
	local l_is_force=false
	
	local tmp_dir="$TMP_DIR"
	
	if [ ! -e $software_archiv ] ; then
		bat_log "No update file found: $software_archiv"
		exit 1
	fi
	
#	Gehe Optionen durch und kopiere entsprechende Verzeichnisse
	declare -a tar_dirs
	idx=0
	for (( i=0; $i<"${#options}"; i++ )); do
		case ${options:$i:1} in
		'f')
			l_is_force=true
			;;
		esac
	done

	#bat_log 'Getting file name and version'	
	
	local file_ver=$(clean_filename -p $software_archiv)
	file_ver=$(echo $file_ver | sed "s|$LINUX_UPDT_FILENAME||g")
	file_ver=$(clean_string $file_ver "_$VERSION_PREFIX")
	file_ver=$(clean_string $file_ver ".tar.gz")
	
	#curr_ver=$(get_current_version "$LINUX_DAEMONS")

	#if [ $l_is_force == false ] && [ ! -z $curr_ver ] && [ $curr_ver -ge $file_ver ] ; then
	#	bat_log 'Linux software is equal or higher than in file'
	#	bat_log 'Exiting software extracting'		
	#	return 0
	#fi

	bat_log 'Temp dir is '"$tmp_dir"
	bat_log 'Extracting archive'	

	#	Archiv entpacken
	if [[ $tmp_dir != "" ]] ; then
		mkdir -p "$tmp_dir"/'update_tmp'
		tar -zxvf $software_archiv -C "$tmp_dir/update_tmp" > /dev/null 2>&1
		tmpdir_daemons="$tmp_dir/update_tmp/$tmpdir_daemons"
		tmpdir_www="$tmp_dir/update_tmp/$tmpdir_www"
		tmpdir_scripts="$tmp_dir/update_tmp/$tmpdir_scripts"
	else
		tar -zxvf $software_archiv > /dev/null 2>&1
	fi
	
	#	Daemons aktualisieren
	#  && ( [ true == $l_is_force ] || [ -z $curr_ver ] || [ $curr_ver -lt $file_ver ] )
	if  test -e "$tmpdir_daemons"  ; then
		bat_log 'Updating daemons'
		cp -Rf "$tmpdir_daemons"/* "$DAEMON_DIR/"
		chmod -R 0777 "$WWW_DIR/"
		rm -Rf "$tmpdir_daemons"
		bat_log "Version of daemons is now $file_ver"
	fi
	
	#curr_ver=$(get_current_version "$LINUX_WWW")
	
	#if [ $l_is_force == false ] || [ ! -z $curr_ver ] && [ $curr_ver -ge $file_ver ] ; then
	#	bat_log 'WWW-software is equal or higher than in file'
	#	bat_log 'Exiting software extracting'		
	#	return 0
	#fi
	
	#	WWW aktualisieren
	#	&& ( [ true == $l_is_force ] || [ -z $curr_ver ] || [ $curr_ver -lt $file_ver ] )
	if  test -e "$tmpdir_www"  ; then
		bat_log 'Updating WWW-interface'
		cp -Rf $tmpdir_www/* "$WWW_DIR/"
		rm -Rf $tmpdir_www
		chmod -R 0777 "$WWW_DIR/"
		bat_log "Version of WWW-interface is now $file_ver"
	fi
	
	
	#	Skripte aktualisieren
	if  test -e "$tmpdir_scripts"  ; then
		bat_log 'Updating bat60 scripts'
		cp -Rf "$tmpdir_scripts"/* "${BAT_SCRIPTS}"
		rm -Rf "$tmpdir_scripts"
		chmod -R 0777 "$tmpdir_scripts/"
		bat_log "Version of bat60 scripts is now $file_ver"
	fi
	
}

is_compress=false
is_extract=false


bat_log 'Determining update options'	

#	Finde, ob ein- oder auspacken
#	Gehe Optionen durch
for (( i=0; $i<${#options}; i++ )); do
	case ${options:$i:1} in
	'c')
		is_compress=true
		;;
	'x')
		is_extract=true
		;;
	esac
done




#	wenn diese gleich sind, wurde keine Option gewaehlt bzw. beide gleichzeitig
if [ $is_compress == $is_extract ] ; then
	bat_log 'Choose either -c or -x option'
	exit 1
fi



if [ true == $is_compress ] ; then
	compress_software $options $archiv_ver_name
elif [ true == $is_extract ] ; then
	mount - / -o remount,rw														# als beschreibbar mounten
	extract_software $options $archiv_ver_name
	set_uboot_bootmode "$UBOOT_BOOTMODE_TRYNORMAL" 
	mount - / -o remount,ro														# wieder als nur lesbar mounten
fi

exit 0 
