#!/bin/bash

# globale Funktionen inkludieren
. '/etc/bat60_scripts/scripts/includes/functions_global.sh'

PROGRESS_VAL_START=15

print_update_msg 'Starting software update ...'
set_progress_bar $PROGRESS_VAL_START

#finde, welche Dateien es zum update gibt
linx_files=$(ls $UPDATE_FILES_DIR | grep "$LINUX_UPDT_FILENAME")
linx_files=$(echo $linx_files)

bat_log 'Getting Linux update files versions'

#	fuer Linuxdateien entferne Linuxupdatedateinamen, _V- und .tar.gz-Zeichenketten#
#	um Versionsnummern von Dateien zu bekommen
linx_ver=$(echo $linx_files | sed "s/$LINUX_UPDT_FILENAME//g" | sed "s/['_V''.tar.gz']//g")
linx_ver=$(echo $linx_ver)

###############################################################################
##		LINUX-UPDATE
##		ACHTUNG !	Nach dem Finden der Update-Datei wird diese entfernt
##

bat_log 'Getting Linux update files'

if [ ! -z "$linx_ver" ] ; then
	
	bat_log 'Linux version found'

	SAVE_IFS=$IFS
	IFS=' ' read -a linx_ver <<< "$linx_ver"									# String in Array splitten
	IFS=$SAVE_IFS

	#bat_log 'Finding last available linux version'

	#	höchste Version finden 
	tmp_version=0
	for element in "${linx_ver[@]}"
	do
	    if [ $tmp_version -lt $element ] ; then
	    	tmp_version=$element
	    fi
	done

	bat_log 'Determining archiv file name'	

	linux_archive=$LINUX_UPDT_FILENAME'_V'$tmp_version'.tar.gz'
	
	####################### Update ################################
	
	#	Pruef, ob eine Datei u.d. update Verzeichnis existiert
	if [ -e $UPDATE_FILES_DIR/$linux_archive ] ; then
		bat_log 'File exists. Starting linux update script'
		#	Archiv entpacken und notwendige Teile aktualisieren
		bash "$BAT_SCRIPTS/update_files/update.sh" -xf "$UPDATE_FILES_DIR/$linux_archive"
	fi
fi	#	! -z "$linx_ver"

PROGRESS_VAL_FINISH=55

set_progress_bar $PROGRESS_VAL_FINISH