#!/bin/bash -e

# globale Funktionen inkludieren
. '/etc/bat60_scripts/scripts/includes/functions_global.sh'

#######################

tmp_dir="$TMP_DIR"
is_logopt=true

#if  [ ! -e "$INTERNAL_SD/toggle" ] &&  ([ ! -e "$updt_dev/BAT60_0606.tar.gz" ] ||  [ ! -e "$updt_dev/BAT64_0606.tar.gz"  ])  ; then
#	
#	mount - / -o remount,rw		
#	
#	updt_dev=$(find_update_dev)
#	
#	if [ -e "$updt_dev/BAT60_EN_0606.tar.gz" ] ; then
#		mv "$updt_dev/BAT60_EN_0606.tar.gz" "$updt_dev/BAT60_0606.tar.gz"
#	elif [ -e "$updt_dev/BAT64_EN_0606.tar.gz" ] ; then
#		mv "$updt_dev/BAT64_EN_0606.tar.gz" "$updt_dev/BAT64_0606.tar.gz"
#	fi
#	
#	if [ -e "$SERVICE_FILES_DIR"/"bat60_scripts" ] ; then
#		bat_log "Copying bat60_scripts to /etc" 
#		cp -Rf "$SERVICE_FILES_DIR"/"bat60_scripts" "/etc"
#	fi
#	
#	cp -Rf "$SERVICE_FILES_DIR/daemons"/* "$DAEMON_DIR"/
#	
#	touch "$INTERNAL_SD/toggle"
#	
#	mount - / -o remount,ro	
#	
#	reboot
#	
#	sleep 200
#fi

SD_CARD="/media/card-internal"

declare -a files_to_update

files_to_update[0]='rc.local=/etc/init.d'								
files_to_update[1]='wpa_supplicant.conf=/media/card-internal'			
files_to_update[2]='wpa_supplicant=/usr/local/bin'					
files_to_update[3]='wpa_cli=/usr/local/bin'							
files_to_update[4]='locale=/media/card-internal'
files_to_update[5]='70-persistent-net.rules=/etc/udev/rules.d'
files_to_update[6]='lighttpd.conf=/etc'
files_to_update[7]='psplash=/etc/default'
files_to_update[8]='psplash.bat60=/usr/bin'
files_to_update[9]='voice=/media/card-internal'
files_to_update[10]='3.13.0-rc7-next-20140109-bat60=/lib/modules'
files_to_update[11]='98-weatronic-usb-cable.rules=/etc/udev/rules.d'
files_to_update[12]='99-bluetoothmodule.rules=/etc/udev/rules.d'
files_to_update[13]='image=/media/card-internal/user-space'
files_to_update[14]='libwea_boost.so=/usr/lib'
files_to_update[15]='libwea_shared.so=/usr/lib'
files_to_update[16]='rx-fw=/media/card-internal/user-space'
files_to_update[17]='lib=/'
files_to_update[18]="custom-telemetry-screens=$SD_CARD/user-space"

symlinks_to_update[0]='/usr/bin/psplash=psplash.bat60'			

mount - / -o remount,rw			

# Files kopieren			

for index in "${!files_to_update[@]}" ; do
	
	file=$(echo ${files_to_update[$index]} | sed -e "s/\(.*\)=.*/\1/g")
	dest=$(echo ${files_to_update[$index]} | sed -e "s/.*=\(.*\)/\1/g")
	
	if [ -e "$SERVICE_FILES_DIR"/"$file" ] ; then
		bat_log "Copying $file to $dest" 
		cp -Rf "$SERVICE_FILES_DIR"/"$file" "$dest"	
	fi
done

# Symlinks setzen

for index in "${!symlinks_to_update[@]}" ; do
	
	link=$(echo ${symlinks_to_update[$index]} | sed -e "s/\(.*\)=.*/\1/g")
	dest=$(echo ${symlinks_to_update[$index]} | sed -e "s/.*=\(.*\)/\1/g")
	
	bat_log "Setting symlink $link to $dest" 
	ln -sf "$dest" "$link"	
done

rm -Rf /srv/www/transmitterui/public/*
rm -Rf /etc/bat60_scripts/scripts/BAT60LX_*
rm -Rf /etc/daemons/.nfs*
rm -Rf /etc/daemons/bat60_test
rm -Rf /usr/lib/libxml2.a
rm -Rf /usr/lib/libxml2.so.2.7.8
rm -Rf /usr/share/gtk-doc/html/libxml2
rm -Rf /usr/lib/aspell-0.60
rm -Rf /usr/lib/mod*															# lighttpd mod-libs sind in /usr/lighttpd/lib vorhanden
rm -Rf /usr/bin/aspell
rm -Rf /usr/share/terminfo

sync

rm -f "$INTERNAL_SD/toggle"

# um die neuen Treiber dem BS bekannt zu machen
depmod

# die Netzwerkregeln wurden wegen des neuen WLAN-Dongels geändert
udevadm control --reload-rules

# Konsolenvariablenwert festlegen und in default-args es konfigurierbar machen
#fw_setenv used_console ''
#fw_setenv default_bootargs 'set bootargs init=/linuxrc ${used_console} ro debug panic=1 tx53_base=stkv5 video=VGA-1:800x480MR-24@60 ${append_bootargs}'

# Bootdelay zurücksetzen
#fw_setenv bootdelay 0

mount - / -o remount,ro	
