


var g_GET_Parameter = get_GET_Parameter();

var g_TelemetryPage = parseInt(g_GET_Parameter.TelemetryPage, 10);
var TelePage = g_TelemetryPage;

var g_TimerValue = parseInt(g_GET_Parameter.TimerValue, 10);
var g_isLocked = parseInt(g_GET_Parameter.isLocked, 10);

if(isNaN(g_isLocked)){
	g_isLocked = 0;
}
else if(g_isLocked){
	showHTML('Footer_Blocker');
	setCSS('Page_Lock', 'visibility', 'visible');
}

if(isNaN(g_TimerValue)){
	g_TimerValue = 0;
}

var g_TimeToLock = -1;
var g_isLockSet = false;
var g_AutoDimm = 0;





initPage();

function initPage(){ 
	$('#Soft_Shutdown').bind('click', function(){shutDown();});


	GetTd(getCurrentModelName(InitDataPostArgs), g_InitEvent);
	GetTd(getScreenAdjustObject(InitDataPostArgs), g_SetEvent, "get");
	GetTd(getGeneralSettingsObject(), g_SetEvent, "get");



	TdPostArgs = getCurrentFlightMode(TdPostArgs);

		
	setInterval(JsonFunction, 250);
}


function getScreenAdjustObject(InitDataPostArgsExtended){
	if(typeof InitDataPostArgsExtended == "undefined"){
		InitDataPostArgsExtended = new Object();
	}
	
	item1 = new Object();
	item1.Index = -1;
	item1.Template = -1;
	item1.TelemetryIds = [];
	
	itemlist = new Array (item1);
	
	InitDataPostArgsExtended["get"] = {};
	InitDataPostArgsExtended["get"]["model-settings"] = {};
	InitDataPostArgsExtended["get"]["model-settings"]["TelemetryScreenAdjustment"] = {};
	InitDataPostArgsExtended["get"]["model-settings"]["TelemetryScreenAdjustment"]["Items"] = "ALL";
	InitDataPostArgsExtended["get"]["model-settings"]["TelemetryScreenAdjustment"]["Item"]= itemlist;
	
	return InitDataPostArgsExtended;	
}


function getGeneralSettingsObject(){
	var InitDataPostArgsGeneral = {};
	InitDataPostArgsGeneral["get"] = {};
	InitDataPostArgsGeneral["get"]["general-settings"] = {};
	InitDataPostArgsGeneral["get"]["general-settings"]["UserSettings"] = {};
	InitDataPostArgsGeneral["get"]["general-settings"]["UserSettings"]["TimeToLock"] = {};
	InitDataPostArgsGeneral["get"]["general-settings"]["UserSettings"]["TimeToLock"]["Index"] = {};
	InitDataPostArgsGeneral["get"]["general-settings"]["UserSettings"]["TimeToLock"]["Name"] = {};
	InitDataPostArgsGeneral["get"]["general-settings"]["UserSettings"]["AutoDimm"] = {};
	InitDataPostArgsGeneral["get"]["general-settings"]["UserSettings"]["AutoDimm"]["Index"] = {};
	InitDataPostArgsGeneral["get"]["general-settings"]["UserSettings"]["AutoDimm"]["Name"] = {};
	
	return InitDataPostArgsGeneral;
}


function onEVENT_INIT(e){
	try{
		setHeaderMaxWidth2();
		setHTML('Model_Name', e.EventData.ModelName);
	}catch(err){
		onError(err, "Error Init: ", false);
	}
}


function handleEventControl(cmd, e, key, value, valueStr){
	
	if(cmd == "telemetry"){
		setHTML(key, valueStr);
	}
		
	
	if(cmd == "flightmode"){
		if(typeof htmlObj_FlightMode == "undefined"){
			htmlObj_FlightMode = document.getElementById('Flight_Mode');
		}

		if(typeof preFlightMode == "undefined"){
			preFlightMode = e.EventData.Current_FM.Index;
			htmlObj_FlightMode.innerHTML = e.EventData.Current_FM.Name;
		}

		if(preFlightMode != e.EventData.Current_FM.Index){
			htmlObj_FlightMode.innerHTML = e.EventData.Current_FM.Name;
			preFlightMode = e.EventData.Current_FM.Index;
		}	
	}	
}


function onEVENT_SET(e){
	try{
		if(e.cmd == "get"){
			if(typeof e.EventData.get.TelemetryScreenAdjustment != "undefined"){
				handleGET(e.EventData.get);
			}
			else{
				g_AutoDimm   = e.EventData.get.UserSettings.AutoDimm.Index;
				g_TimeToLock = e.EventData.get.UserSettings.TimeToLock.Index;

				if(g_TimeToLock > 0){
					g_isLockSet = true;
				}
			}
		}
	}catch(err){
		onError(err, "Error Setdata: ", false);
	}	
}


function handleGET(TdJson){
	
	var numberOfTelepages = TdJson.TelemetryScreenAdjustment.Item.length;
	
	if(numberOfTelepages > 0){
		if(TelePage == 0){
			currentTelePage = numberOfTelepages;
		}
		else{
			currentTelePage = TelePage;
		}

		TelemetryArray = getTemplateTelemetry(TdJson.TelemetryScreenAdjustment.Item[currentTelePage - 1]);





	}
	else{
		currentTelePage = -1;
	}

	

	
	
	
	
	
	





























































	





























	
	
	$('#Telemetry_Arrow_Left').click(function(e){decreaseTelemetryPage(currentTelePage, numberOfTelepages);});						
	
	$('#Telemetry_Arrow_Right').click(function(e){increaseTelemetryPage(currentTelePage, numberOfTelepages);});						

	initChangeToTelemetryPage(currentTelePage, numberOfTelepages);

	
	var TelemetryCSS = {"left": "telemetry_left", "right": "telemetry_right", "midleft": "telemetry_mid_left", "midright": "telemetry_mid_right"};

	htmlTelemetryPage = '';

	if(currentTelePage == -1){
		htmlTelemetryPage += '<div style="width: 754px; height: 315px;"><div style="text-align: center; font-size: 40px; color: #fff; width: 754px; padding-top: 120px;">' + 'Telemetri sayfası tanımlanmamış' + '</div></div>';
	}
	else{
		htmlTelemetryPage += '<div style="width: 754px; border-top: 1px; border-top-style: solid;">';
		var widthcount = 0;
		var	currentHeight = 0;
		var prevHeight = 0;
		var	nextRight = false;
		var	doubleRight = false;
		var	telemetryClass = "";

		for(var i = 0; i < TelemetryArray.length; i++){
			currentHeight = TelemetryArray[i]["point_height"];

			if((widthcount == 0) && (TelemetryArray[i]["point_width"] != 30)){
				telemetryClass= TelemetryCSS["left"];
			}

			if(widthcount > 0){
				telemetryClass = TelemetryCSS["midleft"];
			}

			if(((widthcount + TelemetryArray[i]["point_width"]) == 30) && widthcount != 0){
				telemetryClass = TelemetryCSS["right"];	
			}

			if(nextRight){
				telemetryClass = TelemetryCSS["right"];
				nextRight = false;
				doubleRight = true;
			}

			telemetryObj = new Object();
			telemetryObj.ID = TelemetryArray[i]["ID"];
			telemetryObj.Value = 0;
			telemetryObj.ValueStr = "";

			telemetryIds.push(telemetryObj);

			htmlTelemetryPage += '<div class="' + telemetryClass + '">' +
									  '<div class="telemetry_points' + TelemetryArray[i]["point_width"] + 'x' + TelemetryArray[i]["point_height"] + '">' +
									 	  '<div class="telemetry_name">' +
									 	 	  '<span  id="pilot_timer_name1">' + TelemetryArray[i]["name"] + '</span>' +
									 	  '</div>' +
									 	  '<div class="telemetry_value" id="' + TelemetryArray[i]["ID"] + '">-.-</div>' +
									 	  '<!--<div class="telemetry_unit">' + TelemetryArray[i]["unit"] + '</div>-->' +
									 '</div>' +
								 '</div>';

			widthcount += TelemetryArray[i]["point_width"];

			if((widthcount >= 30) || doubleRight){
				widthcount = 0;
				doubleRight = false;
			}

			if((prevHeight > currentHeight) && (widthcount == 0)){
				nextRight = true;
			}

			prevHeight = currentHeight;
		}

		htmlTelemetryPage += '</div>';
	}

	setHTML('Mode_Content', htmlTelemetryPage);
}

function getTemplateTelemetry(telemetryObj){
	template = telemetryObj.Template;	

	var Telemetry_Array = new Array();

	htmlTemplate = '';

	switch(template){
		case 0: templateBuildOrder = new Array({"Index":0, "width":30, "height": 30}); break; 
		case 1: templateBuildOrder = new Array({"Index":0, "width":20, "height": 15}, {"Index":2, "width":10, "height": 15}, {"Index":1, "width":20, "height": 15}, {"Index":3, "width":10, "height": 15}); break; 
		case 2: templateBuildOrder = new Array({"Index":0, "width":20, "height": 15}, {"Index":2, "width":10, "height": 10}, {"Index":3, "width":10, "height": 10}, {"Index":1, "width":20, "height": 15}, {"Index":4, "width":10, "height": 10}); break;  
		case 3: templateBuildOrder = new Array({"Index":0, "width":20, "height": 10}, {"Index":3, "width":10, "height": 10}, {"Index":1, "width":20, "height": 10}, {"Index":4, "width":10, "height": 10}, {"Index":2, "width":20, "height": 10}, {"Index":5, "width":10, "height": 10}); break;
		case 4: templateBuildOrder = new Array({"Index":0, "width":30, "height": 15}, {"Index":1, "width":30, "height": 15}); break; 
		case 5: templateBuildOrder = new Array({"Index":0, "width":15, "height": 15}, {"Index":2, "width":15, "height": 15}, {"Index":1, "width":15, "height": 15}, {"Index":3, "width":15, "height": 15}); break;
		case 6: templateBuildOrder = new Array({"Index":0, "width":20, "height": 10}, {"Index":3, "width":10, "height": 15}, {"Index":1, "width":20, "height": 10}, {"Index":4, "width":10, "height": 15}, {"Index":2, "width":20, "height": 10}); break;
		case 7: templateBuildOrder = new Array({"Index":0, "width":15, "height": 10}, {"Index":3, "width":15, "height": 10}, {"Index":1, "width":15, "height": 10}, {"Index":4, "width":15, "height": 10}, {"Index":2, "width":15, "height": 10}, {"Index":5, "width":15, "height": 10} ); break;
	}

	for(var i = 0; i < templateBuildOrder.length; i++){
		var Telemetry_Obj = new Object();
		telIndex = templateBuildOrder[i].Index;

		for(var j = 0; j < telemetryObj.TelemetryIds.length; j++){
			if(telIndex == telemetryObj.TelemetryIds[j].Pos){
				Telemetry_Obj["ID"]   = telemetryObj.TelemetryIds[j].Index;
				Telemetry_Obj["name"] = telemetryObj.TelemetryIds[j].Name;
				Telemetry_Obj["unit"] = "unit"; 
				Telemetry_Obj["point_width"]  = templateBuildOrder[i].width; 
				Telemetry_Obj["point_height"] = templateBuildOrder[i].height;
				break;
			}
		}

		Telemetry_Array[i] = Telemetry_Obj;
	}

	return Telemetry_Array;
}


if(navigator.appVersion.indexOf("X11; U; Linux armv7l; c") != -1){
	currentTimeFunction = setInterval(function(){
		LockTimer();
		
	}, 1000);
}


function LockTimer(){
	if(g_isLockSet && !g_isLocked){
		g_TimerValue++;

		if(g_TimerValue >=  g_TimeToLock){
			setCSS('Page_Lock', 'visibility', 'visible');
			showHTML('Footer_Blocker');
			
			g_isLocked = 1;

			if(g_AutoDimm){
				GetTd({"cmd":0x0428, "param": {"Dimmed": 1}}, "noEvent", "command");
			}
		}
	}
}


function ResetLockTimer(){
	g_TimerValue = 0;
	setCSS('Page_Lock', 'visibility', 'hidden');
	hideHTML('Footer_Blocker');
	g_isLocked = 0;

	if(g_AutoDimm){
		GetTd({"cmd":0x0428, "param": {"Dimmed": 0}}, "noEvent", "command");
	}
}


function checkLockState(){
	if(g_isLocked){
		ResetLockTimer();
	}
	else{
		showHTML('Footer_Blocker');
		setCSS('Page_Lock', 'visibility', 'visible');
		g_isLocked = 1;

		if(g_AutoDimm){
			GetTd({"cmd":0x0428, "param": {"Dimmed": 1}}, "noEvent", "command");
		}
	}
}


function increaseTelemetryPage(currentTelePage, numberOfTelepages){
	if((currentTelePage == numberOfTelepages) || (currentTelePage == -1)){
		 window.location.href = "0.1__HomeScreen.html?TimerValue=" + g_TimerValue + "&isLocked=" + g_isLocked;
	}
	else{
		 window.location.href = "0.2__Telemetry.html?TelemetryPage=" + (currentTelePage + 1) + "TimerValue=" + g_TimerValue + "&isLocked=" + g_isLocked;
	}
}


function decreaseTelemetryPage(){
	if((currentTelePage == 1) || (currentTelePage == -1)){
		 window.location.href = "0.1__HomeScreen.html?TimerValue=" + g_TimerValue + "&isLocked=" + g_isLocked;
	}
	else{
		 window.location.href = "0.2__Telemetry.html?TelemetryPage=" + (currentTelePage - 1) + "TimerValue=" + g_TimerValue + "&isLocked=" + g_isLocked;
	}
}


function initChangeToTelemetryPage(currentTelePage, numberOfTelepages){
	if(navigator.appVersion.indexOf("X11; U; Linux armv7l; c") != -1){
		
		otherPlatform = false;
	}
	else{
		
		otherPlatform = true;
	}
	
	if(!otherPlatform){
		$(window).keypress(function (e){
			var c = e.charCode;
			
			if((c == CONST_SCROLLING_Key_e) || (c == CONST_SCROLLING_Key_d) || (c == CONST_SCROLLING_Key_c)){
				increaseTelemetryPage(currentTelePage, numberOfTelepages);
			}

			
			if((c == CONST_SCROLLING_Key_w) || (c == CONST_SCROLLING_Key_s)|| (c == CONST_SCROLLING_Key_x)){
				decreaseTelemetryPage(currentTelePage, numberOfTelepages);
			}
		});
	}
}


function setHeaderMaxWidth2(){
	var pageNameWidth = document.getElementById('Telemetry_Label').offsetWidth;
	var subDivWidth = (480 - pageNameWidth)/2;
	setCSS('Model_Name', 'maxWidth', subDivWidth + 'px');
	setCSS('Flight_Mode', 'maxWidth', subDivWidth + 'px');
}
